/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.arquillian.drone.impl.DroneLifecycleManager;
import org.jboss.arquillian.drone.impl.DroneTimeoutException;
import org.jboss.arquillian.drone.spi.CachingCallable;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.Filter;
import org.jboss.arquillian.drone.spi.InjectionPoint;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneContextImpl
implements DroneContext {
    private static final Logger LOGGER = Logger.getLogger(DroneContextImpl.class.getName());
    private final Map<InjectionPoint<?>, DronePair<?, ?>> dronePairMap = new HashMap();
    @Deprecated
    private DroneConfiguration<?> globalDroneConfiguration;
    @Inject
    private Instance<ExecutorService> executorService;
    @Inject
    private Event<BeforeDroneInstantiated> beforeDroneInstantiatedEvent;
    @Inject
    private Event<AfterDroneInstantiated> afterDroneInstantiatedEvent;

    public <C extends DroneConfiguration<C>> C getGlobalDroneConfiguration(Class<C> configurationClass) {
        return (C)this.globalDroneConfiguration;
    }

    public void setGlobalDroneConfiguration(DroneConfiguration<?> configuration) {
        this.globalDroneConfiguration = configuration;
    }

    public <T> T getDrone(InjectionPoint<T> injectionPoint) throws IllegalStateException {
        CachingCallable<?> newDroneCallable;
        boolean newInstance;
        DronePair<?, ?> pair = this.dronePairMap.get(injectionPoint);
        if (pair == null) {
            throw new IllegalArgumentException(MessageFormat.format("Injection point doesn''t exist: {0}", injectionPoint));
        }
        CachingCallable<?> droneCallable = pair.getDroneCallable();
        if (droneCallable == null) {
            throw new IllegalStateException(MessageFormat.format("Drone callable not stored yet for injection point {0}!", injectionPoint));
        }
        boolean bl = newInstance = !droneCallable.isValueCached();
        if (newInstance) {
            this.beforeDroneInstantiatedEvent.fire((Object)new BeforeDroneInstantiated(injectionPoint));
        }
        Object drone = this.instantiateDrone(droneCallable);
        if (newInstance) {
            this.afterDroneInstantiatedEvent.fire((Object)new AfterDroneInstantiated(drone, injectionPoint));
        }
        if ((newDroneCallable = pair.getDroneCallable()) != droneCallable) {
            return this.getDrone(injectionPoint);
        }
        return (T)drone;
    }

    private <T> T instantiateDrone(CachingCallable<T> droneCallable) {
        int timeout = this.getGlobalDroneConfiguration(DroneLifecycleManager.GlobalDroneConfiguration.class).getInstantiationTimeoutInSeconds();
        try {
            Future futureDrone = ((ExecutorService)this.executorService.get()).submit(droneCallable);
            Object drone = timeout > 0 ? futureDrone.get(timeout, TimeUnit.SECONDS) : futureDrone.get();
            return (T)drone;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance, thread interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (DroneTimeoutException.isCausedByTimeoutException(cause)) {
                throw new DroneTimeoutException(timeout, cause);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause.getMessage(), cause);
        }
        catch (TimeoutException e) {
            throw new DroneTimeoutException(timeout, (Throwable)e);
        }
    }

    public <C extends DroneConfiguration<C>> C getDroneConfiguration(InjectionPoint<?> injectionPoint, Class<C> configurationClass) throws IllegalArgumentException {
        DronePair<?, ?> pair = this.dronePairMap.get(injectionPoint);
        if (pair == null) {
            throw new IllegalArgumentException(MessageFormat.format("Injection point doesn''t exist: {0}", injectionPoint));
        }
        Object configuration = pair.getConfiguration();
        if (configuration == null) {
            throw new IllegalStateException(MessageFormat.format("Drone configuration not stored yet! Injection point: {0}", injectionPoint));
        }
        return (C)configuration;
    }

    public <T> void storeFutureDrone(InjectionPoint<T> injectionPoint, CachingCallable<T> drone) {
        DronePair<?, ?> pair = this.dronePairMap.get(injectionPoint);
        if (pair == null) {
            throw new IllegalArgumentException(MessageFormat.format("Injection point doesn''t exist: {0}", injectionPoint));
        }
        if (pair.getDroneCallable() != null) {
            LOGGER.log(Level.FINE, "Future drone replaced at point {0}", injectionPoint);
        }
        pair.setDroneCallable(drone);
    }

    public <T, C extends DroneConfiguration<C>> void storeDroneConfiguration(InjectionPoint<T> injectionPoint, C configuration) {
        DronePair<Object, Object> pair = this.dronePairMap.get(injectionPoint);
        if (pair != null) {
            throw new IllegalStateException(MessageFormat.format("Injection point already exists: {0}", injectionPoint));
        }
        pair = new DronePair();
        pair.setConfiguration(configuration);
        this.dronePairMap.put(injectionPoint, pair);
    }

    public <T> boolean isDroneInstantiated(InjectionPoint<T> injectionPoint) {
        DronePair<?, ?> dronePair = this.dronePairMap.get(injectionPoint);
        if (dronePair == null) {
            return false;
        }
        if (dronePair.getDroneCallable() == null) {
            return false;
        }
        return dronePair.getDroneCallable().isValueCached();
    }

    public <T> boolean isFutureDroneStored(InjectionPoint<T> injectionPoint) {
        DronePair<?, ?> dronePair = this.dronePairMap.get(injectionPoint);
        if (dronePair == null) {
            return false;
        }
        return dronePair.getDroneCallable() != null;
    }

    public <T> boolean isDroneConfigurationStored(InjectionPoint<T> injectionPoint) {
        DronePair<?, ?> dronePair = this.dronePairMap.get(injectionPoint);
        if (dronePair == null) {
            return false;
        }
        return dronePair.getConfiguration() != null;
    }

    public void removeDrone(InjectionPoint<?> injectionPoint) {
        DronePair<?, ?> pair = this.dronePairMap.get(injectionPoint);
        if (pair == null) {
            LOGGER.log(Level.WARNING, "Couldn''t remove Drone, because it wasn''t prepared! Injection point: {0}", injectionPoint);
            return;
        }
        if (pair.getDroneCallable() == null) {
            LOGGER.log(Level.WARNING, "Couldn''t remove Drone, because it wasn''t set! Injection point: {0}", injectionPoint);
        }
        pair.setDroneCallable(null);
    }

    public void removeDroneConfiguration(InjectionPoint<?> injectionPoint) {
        DronePair<?, ?> pair = this.dronePairMap.get(injectionPoint);
        if (pair == null) {
            LOGGER.log(Level.WARNING, "Couldn''t remove configuration, because the injection point wasn''t prepared. Injection point: {0}", injectionPoint);
            return;
        }
        if (pair.getDroneCallable() != null) {
            LOGGER.log(Level.WARNING, "Drone is still set, but you won''t be able to access it anymore! Injection point: {0}", injectionPoint);
        }
        if (pair.getConfiguration() == null) {
            LOGGER.log(Level.WARNING, "Couldn''t remove configuration, because it wasn''t set! Injection point: {0}", injectionPoint);
        }
        pair.setConfiguration(null);
        this.dronePairMap.remove(injectionPoint);
    }

    public void removeDrones(List<InjectionPoint<?>> injectionPoints) {
        for (InjectionPoint<?> injectionPoint : injectionPoints) {
            this.removeDrone(injectionPoint);
        }
    }

    public void removeDroneConfigurations(List<InjectionPoint<?>> injectionPoints) {
        for (InjectionPoint<?> injectionPoint : injectionPoints) {
            this.removeDroneConfiguration(injectionPoint);
        }
    }

    public <T> InjectionPoint<? extends T> findSingle(Class<T> droneClass, Filter ... filters) throws IllegalStateException {
        List<InjectionPoint<T>> injectionPoints = this.find(droneClass, filters);
        int count = injectionPoints.size();
        if (count != 1) {
            throw new IllegalStateException("Total injection points matched not equal to 1! Actual: " + count);
        }
        return injectionPoints.get(0);
    }

    public <T> List<InjectionPoint<? extends T>> find(Class<T> droneClass, Filter ... filters) {
        ArrayList<InjectionPoint<T>> matchedInjectionPoints = new ArrayList<InjectionPoint<T>>();
        for (InjectionPoint<?> injectionPoint : this.dronePairMap.keySet()) {
            if (!droneClass.isAssignableFrom(injectionPoint.getDroneType())) continue;
            InjectionPoint<?> castInjectionPoint = injectionPoint;
            boolean matches = true;
            for (Filter filter : filters) {
                if (filter.accept(castInjectionPoint)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            matchedInjectionPoints.add(castInjectionPoint);
        }
        return matchedInjectionPoints;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DronePair<T, C extends DroneConfiguration<C>> {
        private CachingCallable<T> droneCallable;
        private C configuration;

        private DronePair() {
        }

        public CachingCallable<T> getDroneCallable() {
            return this.droneCallable;
        }

        public void setDroneCallable(CachingCallable<T> droneCallable) {
            this.droneCallable = droneCallable;
        }

        public C getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(C configuration) {
            this.configuration = configuration;
        }
    }
}

