/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.InjectionPoint;
import org.jboss.arquillian.drone.spi.command.DestroyDrone;
import org.jboss.arquillian.drone.spi.event.AfterDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneDestructor {
    private static final Logger log = Logger.getLogger(DroneDestructor.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<DroneRegistry> registry;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;
    @Inject
    private Event<DestroyDrone> destroyDroneCommand;
    @Inject
    private Instance<DroneContext> droneContext;

    public void destroyDrone(@Observes DestroyDrone command) {
        DroneContext context = (DroneContext)this.droneContext.get();
        InjectionPoint injectionPoint = command.getInjectionPoint();
        if (injectionPoint == null || !context.isDroneConfigurationStored(injectionPoint)) {
            return;
        }
        boolean wasInstantiated = context.isDroneInstantiated(injectionPoint);
        if (wasInstantiated) {
            Destructor destructor = this.getDestructorFor(injectionPoint.getDroneType());
            Object drone = context.getDrone(injectionPoint);
            this.droneLifecycleEvent.fire((Object)new BeforeDroneDestroyed(drone, injectionPoint));
            drone = context.getDrone(injectionPoint);
            destructor.destroyInstance(drone);
        }
        context.removeDrone(injectionPoint);
        context.removeDroneConfiguration(injectionPoint);
        if (wasInstantiated) {
            this.droneLifecycleEvent.fire((Object)new AfterDroneDestroyed(injectionPoint));
        }
    }

    private Destructor getDestructorFor(Class<?> typeClass) {
        Destructor destructor = (Destructor)((DroneRegistry)this.registry.get()).getEntryFor(typeClass, Destructor.class);
        if (log.isLoggable(Level.FINER)) {
            log.fine("Using destructor defined in class: " + destructor.getClass().getName() + ", with precedence " + destructor.getPrecedence());
        }
        return destructor;
    }
}

