/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.api.annotation.lifecycle.ClassLifecycle;
import org.jboss.arquillian.drone.api.annotation.lifecycle.MethodLifecycle;
import org.jboss.arquillian.drone.impl.DeploymentLifecycleInjectionPointImpl;
import org.jboss.arquillian.drone.impl.InjectionPointImpl;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionPoints {
    private InjectionPoints() {
    }

    static Set<InjectionPoint<?>> allInClass(Class<?> cls) {
        ArrayList injectionPoints = new ArrayList();
        injectionPoints.addAll(InjectionPoints.fieldsInClass(cls).values());
        for (InjectionPoint<?>[] methodInjectionPoints : InjectionPoints.parametersInClass(cls).values()) {
            for (InjectionPoint<?> injectionPoint : methodInjectionPoints) {
                if (injectionPoint == null) continue;
                injectionPoints.add(injectionPoint);
            }
        }
        return new HashSet(injectionPoints);
    }

    static Map<Field, InjectionPoint<?>> fieldsInClass(Class<?> cls) {
        HashMap injectionPoints = new HashMap();
        List<Field> fields = SecurityActions.getFieldsWithAnnotation(cls, Drone.class);
        for (Field field : fields) {
            InjectionPoint<?> injectionPoint = InjectionPoints.resolveInjectionPoint(field);
            injectionPoints.put(field, injectionPoint);
        }
        return injectionPoints;
    }

    static Map<Method, InjectionPoint<?>[]> parametersInClass(Class<?> cls) {
        Method[] methods;
        HashMap<Method, InjectionPoint<?>[]> mergedInjectionPoints = new HashMap<Method, InjectionPoint<?>[]>();
        for (Method method : methods = cls.getMethods()) {
            InjectionPoint<?>[] injectionPoints = InjectionPoints.parametersInMethod(method);
            mergedInjectionPoints.put(method, injectionPoints);
        }
        return mergedInjectionPoints;
    }

    static InjectionPoint<?>[] parametersInMethod(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        Map<Integer, Annotation[]> droneParameters = SecurityActions.getParametersWithAnnotation(method, Drone.class);
        InjectionPoint[] injectionPoints = new InjectionPoint[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            InjectionPoint<?> injectionPoint;
            if (!droneParameters.containsKey(i)) {
                injectionPoints[i] = null;
                continue;
            }
            Annotation[] parameterAnnotations = droneParameters.get(i);
            Class<?> droneType = parameters[i];
            injectionPoints[i] = injectionPoint = InjectionPoints.resolveInjectionPoint(droneType, parameterAnnotations);
        }
        return injectionPoints;
    }

    static InjectionPoint<?> resolveInjectionPoint(Field field) {
        Class<?> droneType = field.getType();
        Class<? extends Annotation> qualifier = SecurityActions.getQualifier(field);
        Class<? extends Annotation> scopeAnnotation = SecurityActions.getScope(field);
        OperateOnDeployment operateOnDeployment = SecurityActions.getAnnotation(field, OperateOnDeployment.class);
        return InjectionPoints.createInjectionPoint(droneType, qualifier, scopeAnnotation, InjectionPoint.Lifecycle.CLASS, operateOnDeployment);
    }

    static <T> InjectionPoint<T> resolveInjectionPoint(Class<T> droneType, Annotation[] parameterAnnotations) {
        Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations);
        Class<? extends Annotation> scopeAnnotation = SecurityActions.getScope(parameterAnnotations);
        OperateOnDeployment operateOnDeployment = SecurityActions.findAnnotation(parameterAnnotations, OperateOnDeployment.class);
        return InjectionPoints.createInjectionPoint(droneType, qualifier, scopeAnnotation, InjectionPoint.Lifecycle.METHOD, operateOnDeployment);
    }

    static <T> InjectionPoint<T> createInjectionPoint(Class<T> droneType, Class<? extends Annotation> qualifier, Class<? extends Annotation> scopeAnnotation, InjectionPoint.Lifecycle defaultLifecycle, OperateOnDeployment operateOnDeployment) {
        InjectionPoint.Lifecycle lifecycle = InjectionPoints.scopeForAnnotation(scopeAnnotation, operateOnDeployment, defaultLifecycle);
        if (lifecycle == InjectionPoint.Lifecycle.DEPLOYMENT) {
            String deployment = operateOnDeployment.value();
            return new DeploymentLifecycleInjectionPointImpl<T>(droneType, qualifier, lifecycle, deployment);
        }
        return new InjectionPointImpl<T>(droneType, qualifier, lifecycle);
    }

    static InjectionPoint.Lifecycle scopeForAnnotation(Class<? extends Annotation> annotation, OperateOnDeployment deployment, InjectionPoint.Lifecycle defaultLifecycle) {
        if (annotation == ClassLifecycle.class) {
            return InjectionPoint.Lifecycle.CLASS;
        }
        if (annotation == MethodLifecycle.class) {
            return InjectionPoint.Lifecycle.METHOD;
        }
        if (deployment != null) {
            return InjectionPoint.Lifecycle.DEPLOYMENT;
        }
        return defaultLifecycle;
    }
}

