/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.impl.CachingCallableImpl;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.CachingCallable;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.command.PrepareDrone;
import org.jboss.arquillian.drone.spi.event.AfterDronePrepared;
import org.jboss.arquillian.drone.spi.event.BeforeDronePrepared;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneConfigurator {
    private static Logger logger = Logger.getLogger(DroneConfigurator.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Event<BeforeDronePrepared> beforeDronePreparedEvent;
    @Inject
    private Event<AfterDronePrepared> afterDronePreparedEvent;

    public void prepareDrone(@Observes PrepareDrone command, DroneRegistry registry) {
        DronePoint dronePoint = command.getDronePoint();
        this.prepare(dronePoint, registry);
    }

    private <DRONE> void prepare(DronePoint<DRONE> dronePoint, DroneRegistry registry) {
        Validate.stateNotNull(this.droneContext.get(), "DroneContext should be available while working with method scoped instances", new Object[0]);
        Configurator<DRONE, ?> droneConfigurator = this.getDroneConfigurator(registry, dronePoint);
        Instantiator callableInstantiator = this.getCallableInstantiator(registry, dronePoint);
        if (droneConfigurator != null || callableInstantiator != null) {
            this.beforeDronePreparedEvent.fire((Object)new BeforeDronePrepared(droneConfigurator, callableInstantiator, dronePoint));
            this.performDronePreparation(dronePoint, droneConfigurator, callableInstantiator);
            this.afterDronePreparedEvent.fire((Object)new AfterDronePrepared(dronePoint));
        }
    }

    private <DRONE> void performDronePreparation(final DronePoint<DRONE> dronePoint, Configurator<DRONE, ?> droneConfigurator, final Instantiator instantiator) {
        final DroneContext context = (DroneContext)this.droneContext.get();
        ArquillianDescriptor descriptor = (ArquillianDescriptor)this.arquillianDescriptor.get();
        Validate.stateNotNull(descriptor, "ArquillianDescriptor should not be null", new Object[0]);
        DroneConfiguration configuration = droneConfigurator.createConfiguration(descriptor, dronePoint);
        context.get(dronePoint).setConfiguration(configuration);
        CachingCallableImpl futureDrone = new CachingCallableImpl<DRONE>(){

            @Override
            protected DRONE createInstance() throws Exception {
                DroneConfiguration configuration = context.get(dronePoint).getConfigurationAs(DroneConfiguration.class);
                return instantiator.createInstance(configuration);
            }
        };
        context.get(dronePoint).setFutureInstance((CachingCallable)futureDrone);
    }

    private <DRONE> Configurator<DRONE, ?> getDroneConfigurator(DroneRegistry registry, DronePoint<DRONE> dronePoint) {
        if (((DroneContext)this.droneContext.get()).get(dronePoint).hasConfiguration()) {
            logger.log(Level.WARNING, "Could not configure drone for injection point {0}, because it was already configured!", dronePoint);
            return null;
        }
        return (Configurator)registry.getEntryFor(dronePoint.getDroneType(), Configurator.class);
    }

    private <DRONE> Instantiator getCallableInstantiator(DroneRegistry registry, DronePoint<DRONE> dronePoint) {
        if (((DroneContext)this.droneContext.get()).get(dronePoint).hasFutureInstance()) {
            logger.log(Level.WARNING, "Could not create drone callable for injection point {0}, because it was already created!", dronePoint);
            return null;
        }
        Instantiator instantiator = (Instantiator)registry.getEntryFor(dronePoint.getDroneType(), Instantiator.class);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", " + "with precedence " + instantiator.getPrecedence());
        }
        return instantiator;
    }
}

