/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.impl.DronePointContextImpl;
import org.jboss.arquillian.drone.impl.FilterableResultImpl;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointContext;
import org.jboss.arquillian.drone.spi.FilterableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneContextImpl
implements DroneContext {
    private static final Logger LOGGER = Logger.getLogger(DroneContextImpl.class.getName());
    private final Map<DronePoint<?>, DronePointContext<?>> droneContextMap = new HashMap();
    @Inject
    private Instance<Injector> injector;
    @Deprecated
    private DroneConfiguration<?> globalDroneConfiguration;

    public <C extends DroneConfiguration<C>> C getGlobalDroneConfiguration(Class<C> configurationClass) {
        return (C)this.globalDroneConfiguration;
    }

    public void setGlobalDroneConfiguration(DroneConfiguration<?> configuration) {
        this.globalDroneConfiguration = configuration;
    }

    public <DRONE> DronePointContext<DRONE> get(DronePoint<DRONE> dronePoint) {
        if (!this.droneContextMap.containsKey(dronePoint)) {
            DronePointContext pointContext = (DronePointContext)((Injector)this.injector.get()).inject(new DronePointContextImpl<DRONE>(dronePoint));
            this.droneContextMap.put(dronePoint, pointContext);
        }
        return this.droneContextMap.get(dronePoint);
    }

    public <DRONE> boolean contains(DronePoint<DRONE> dronePoint) {
        return this.droneContextMap.containsKey(dronePoint);
    }

    public <DRONE> void remove(DronePoint<DRONE> dronePoint) {
        this.droneContextMap.remove(dronePoint);
    }

    public <DRONE> FilterableResult<DRONE> find(Class<DRONE> droneClass) {
        HashSet matchedDronePoints = new HashSet();
        for (DronePoint<?> dronePoint : this.droneContextMap.keySet()) {
            if (!dronePoint.conformsTo(droneClass)) continue;
            DronePoint<?> castDronePoint = dronePoint;
            matchedDronePoints.add(castDronePoint);
        }
        return new FilterableResultImpl(this, matchedDronePoints);
    }
}

