/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.impl.DeploymentDronePointsRegistry;
import org.jboss.arquillian.drone.impl.DroneContextImpl;
import org.jboss.arquillian.drone.impl.DroneTestEnricher;
import org.jboss.arquillian.drone.impl.InjectionPoints;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointFilter;
import org.jboss.arquillian.drone.spi.FilterableResult;
import org.jboss.arquillian.drone.spi.command.DestroyDrone;
import org.jboss.arquillian.drone.spi.command.PrepareDrone;
import org.jboss.arquillian.drone.spi.event.AfterDroneExtensionConfigured;
import org.jboss.arquillian.drone.spi.event.BeforeDroneExtensionConfigured;
import org.jboss.arquillian.drone.spi.filter.DeploymentFilter;
import org.jboss.arquillian.drone.spi.filter.LifecycleFilter;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class DroneLifecycleManager {
    private static final Logger log = Logger.getLogger(DroneLifecycleManager.class.getName());
    public static final int CLASS_SCAN_PRECEDENCE = 75;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    @ApplicationScoped
    private InstanceProducer<DroneContext> droneContext;
    @Inject
    @ApplicationScoped
    private InstanceProducer<DeploymentDronePointsRegistry> deploymentDronePointsRegistry;
    @Inject
    private Event<BeforeDroneExtensionConfigured> beforeDroneExtensionConfiguredEvent;
    @Inject
    private Event<AfterDroneExtensionConfigured> afterDroneExtensionConfiguredEvent;
    @Inject
    private Event<PrepareDrone> createDroneConfigurationCommand;
    @Inject
    private Event<DestroyDrone> destroyDroneCommand;
    @Inject
    private Instance<TestClass> testClassInstance;

    public void managerStarted(@Observes ManagerStarted event) {
        try {
            DroneContext context = (DroneContext)((Injector)this.injector.get()).inject((Object)new DroneContextImpl());
            this.droneContext.set((Object)context);
        }
        catch (TypeNotPresentException e) {
            log.log(Level.SEVERE, "Unable to create Drone Context due to missing services on classpath. Please make sure to use Arquillian Core 1.1.4.Final or later.");
            throw new IllegalStateException("Unable to create Drone Context due to missing services on classpath. Please make sure to use Arquillian Core 1.1.4.Final or later.", e);
        }
    }

    public void configureDroneExtension(@Observes BeforeSuite event) {
        DroneContext context = (DroneContext)this.droneContext.get();
        if (context.getGlobalDroneConfiguration(DroneConfiguration.class) != null) {
            return;
        }
        this.beforeDroneExtensionConfiguredEvent.fire((Object)new BeforeDroneExtensionConfigured());
        if (context.getGlobalDroneConfiguration(DroneConfiguration.class) == null) {
            DroneConfiguration configuration = new GlobalDroneConfiguration().configure((ArquillianDescriptor)this.arquillianDescriptor.get(), (Class)null);
            context.setGlobalDroneConfiguration(configuration);
        }
        this.afterDroneExtensionConfiguredEvent.fire((Object)new AfterDroneExtensionConfigured());
    }

    public void beforeClass(@Observes(precedence=75) BeforeClass event) {
        Class testClass = event.getTestClass().getJavaClass();
        Set<DronePoint<?>> dronePoints = InjectionPoints.allInClass((DroneContext)this.droneContext.get(), testClass);
        for (DronePoint<?> dronePoint : dronePoints) {
            if (dronePoint.getLifecycle() == DronePoint.Lifecycle.DEPLOYMENT) {
                this.registerDeploymentDronePoint(dronePoint);
                continue;
            }
            if (dronePoint.getLifecycle() == DronePoint.Lifecycle.METHOD) continue;
            this.createDroneConfigurationCommand.fire((Object)new PrepareDrone(dronePoint));
        }
    }

    private void registerDeploymentDronePoint(DronePoint dronePoint) {
        if (this.deploymentDronePointsRegistry.get() == null) {
            this.deploymentDronePointsRegistry.set(((Injector)this.injector.get()).inject((Object)new DeploymentDronePointsRegistry()));
        }
        ((DeploymentDronePointsRegistry)this.deploymentDronePointsRegistry.get()).addDronePoint(dronePoint, null);
    }

    public void before(@Observes Before event) {
        DronePoint<?>[] dronePoints;
        for (DronePoint<?> dronePoint : dronePoints = InjectionPoints.parametersInMethod((DroneContext)this.droneContext.get(), event.getTestMethod())) {
            if (dronePoint == null || dronePoint.getLifecycle() != DronePoint.Lifecycle.METHOD) continue;
            this.createDroneConfigurationCommand.fire((Object)new PrepareDrone(dronePoint));
        }
    }

    public void afterDeploy(@Observes AfterDeploy afterDeploy) {
        DeploymentDronePointsRegistry deplDronePoints = (DeploymentDronePointsRegistry)this.deploymentDronePointsRegistry.get();
        if (deplDronePoints != null) {
            String deplName = afterDeploy.getDeployment().getName();
            Map<DronePoint<?>, Object> filteredDronePoints = deplDronePoints.filterDeploymentDronePoints(deplName);
            for (DronePoint<?> dronePoint : filteredDronePoints.keySet()) {
                Object testClass;
                if (!((DroneContext)this.droneContext.get()).get(dronePoint).hasFutureInstance()) {
                    this.createDroneConfigurationCommand.fire((Object)new PrepareDrone(dronePoint));
                }
                if ((testClass = filteredDronePoints.get(dronePoint)) == null) continue;
                DroneTestEnricher droneTestEnricher = (DroneTestEnricher)((Injector)this.injector.get()).inject((Object)new DroneTestEnricher());
                droneTestEnricher.enrichTestClass(((TestClass)this.testClassInstance.get()).getJavaClass(), testClass, false);
            }
        }
    }

    public void after(@Observes After event) {
        DroneContext context = (DroneContext)this.droneContext.get();
        LifecycleFilter lifecycleFilter = new LifecycleFilter(DronePoint.Lifecycle.METHOD, new DronePoint.Lifecycle[0]);
        FilterableResult dronePoints = context.find(Object.class).filter((DronePointFilter)lifecycleFilter);
        for (DronePoint dronePoint : dronePoints) {
            this.destroyDroneCommand.fire((Object)new DestroyDrone(dronePoint));
        }
    }

    public void beforeUndeploy(@Observes BeforeUnDeploy event) {
        DroneContext context = (DroneContext)this.droneContext.get();
        DeploymentFilter deploymentFilter = new DeploymentFilter(Pattern.quote(event.getDeployment().getName()));
        LifecycleFilter lifecycleFilter = new LifecycleFilter(DronePoint.Lifecycle.DEPLOYMENT, new DronePoint.Lifecycle[0]);
        FilterableResult dronePoints = context.find(Object.class).filter((DronePointFilter)deploymentFilter).filter((DronePointFilter)lifecycleFilter);
        for (DronePoint dronePoint : dronePoints) {
            this.destroyDroneCommand.fire((Object)new DestroyDrone(dronePoint));
        }
    }

    public void afterClass(@Observes AfterClass event) {
        DroneContext context = (DroneContext)this.droneContext.get();
        LifecycleFilter lifecycleFilter = new LifecycleFilter(DronePoint.Lifecycle.CLASS, new DronePoint.Lifecycle[]{DronePoint.Lifecycle.METHOD});
        FilterableResult dronePoints = context.find(Object.class).filter((DronePointFilter)lifecycleFilter);
        for (DronePoint dronePoint : dronePoints) {
            this.destroyDroneCommand.fire((Object)new DestroyDrone(dronePoint));
        }
    }

    @Deprecated
    public static class GlobalDroneConfiguration
    implements DroneConfiguration<GlobalDroneConfiguration> {
        public static final String CONFIGURATION_NAME = "drone";
        public static final int DEFAULT_INSTANTIATION_TIMEOUT = 60;
        private int instantiationTimeoutInSeconds = 60;

        public String getConfigurationName() {
            return CONFIGURATION_NAME;
        }

        public GlobalDroneConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
            ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, Default.class);
            if (Boolean.parseBoolean(SecurityActions.getProperty("arquillian.debug"))) {
                this.instantiationTimeoutInSeconds = 0;
            }
            return this;
        }

        public int getInstantiationTimeoutInSeconds() {
            return this.instantiationTimeoutInSeconds;
        }

        public void setInstantiationTimeoutInSeconds(int instantiationTimeoutInSeconds) {
            this.instantiationTimeoutInSeconds = instantiationTimeoutInSeconds;
        }
    }
}

