/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.Sortable;

public class DroneRegistryImpl
implements DroneRegistry {
    private final Map<Class<?>, RegistryValue> registry = new HashMap();

    DroneRegistryImpl() {
    }

    public DroneRegistry registerConfiguratorFor(Class<?> key, Configurator<?, ?> configurator) {
        RegistryValue entry = this.registry.get(key);
        if (entry != null) {
            entry.configurator = configurator;
        } else {
            this.registry.put(key, new RegistryValue().setConfigurator(configurator));
        }
        return this;
    }

    public DroneRegistry registerInstantiatorFor(Class<?> key, Instantiator<?, ?> value) {
        RegistryValue entry = this.registry.get(key);
        if (entry != null) {
            entry.instantiator = value;
        } else {
            this.registry.put(key, new RegistryValue().setInstantiator(value));
        }
        return this;
    }

    public DroneRegistry registerDestructorFor(Class<?> key, Destructor<?> value) {
        RegistryValue entry = this.registry.get(key);
        if (entry != null) {
            entry.destructor = value;
        } else {
            this.registry.put(key, new RegistryValue().setDestructor(value));
        }
        return this;
    }

    public <T extends Sortable> T getEntryFor(Class<?> key, Class<T> entryType) throws IllegalStateException {
        RegisteredType regType = RegisteredType.getType(entryType);
        RegistryValue value = this.registry.get(key);
        if (value == null) {
            throw new IllegalStateException(this.getUnregisteredExceptionMessage(key, regType));
        }
        if (!regType.registeredIn(value)) {
            throw new IllegalStateException(this.getUnregisteredExceptionMessage(key, regType));
        }
        return regType.unwrap(value, entryType);
    }

    String getUnregisteredExceptionMessage(Class<?> unregistered, RegisteredType registeredType) {
        StringBuilder sb = new StringBuilder();
        sb.append("No " + (Object)((Object)registeredType) + " was found for object of type " + unregistered.getName() + ".\nMake sure you have Drone extension depchain for the given browser on the classpath, that is org.jboss.arquillian.extension:arquillian-drone-webdriver-depchain:pom for WebDriver browsers, org.jboss.arquillian.extension:arquillian-drone-selenium-depchain:pom for Selenium 1 browsers and org.jboss.arquillian.graphene:graphene-webdriver:pom for Graphene2 browsers. If you are using different browser extension, please make sure it is on classpath.\n");
        sb.append("Currently registered " + (Object)((Object)registeredType) + "s are: ");
        for (Map.Entry<Class<?>, RegistryValue> entry : this.registry.entrySet()) {
            if (!registeredType.registeredIn(entry.getValue())) continue;
            sb.append(entry.getKey().getName()).append("\n");
        }
        return sb.toString();
    }

    private static enum RegisteredType {
        CONFIGURATOR{

            @Override
            public boolean registeredIn(RegistryValue value) {
                return value.configurator != null;
            }

            public String toString() {
                return "configurator";
            }

            @Override
            public <T extends Sortable> T unwrap(RegistryValue value, Class<T> unwrapClass) {
                if (this.registeredIn(value)) {
                    return (T)((Sortable)unwrapClass.cast(value.configurator));
                }
                return null;
            }
        }
        ,
        INSTANTIATOR{

            @Override
            public boolean registeredIn(RegistryValue value) {
                return value.instantiator != null;
            }

            public String toString() {
                return "instantiator";
            }

            @Override
            public <T extends Sortable> T unwrap(RegistryValue value, Class<T> unwrapClass) {
                if (this.registeredIn(value)) {
                    return (T)((Sortable)unwrapClass.cast(value.instantiator));
                }
                return null;
            }
        }
        ,
        DESTRUCTOR{

            @Override
            public boolean registeredIn(RegistryValue value) {
                return value.destructor != null;
            }

            public String toString() {
                return "destructor";
            }

            @Override
            public <T extends Sortable> T unwrap(RegistryValue value, Class<T> unwrapClass) {
                if (this.registeredIn(value)) {
                    return (T)((Sortable)unwrapClass.cast(value.destructor));
                }
                return null;
            }
        };


        public abstract boolean registeredIn(RegistryValue var1);

        public abstract <T extends Sortable> T unwrap(RegistryValue var1, Class<T> var2);

        public static RegisteredType getType(Class<? extends Sortable> registeredType) {
            Validate.stateNotNull(registeredType, "Registered type must not be null", new Object[0]);
            if (Configurator.class.isAssignableFrom(registeredType)) {
                return CONFIGURATOR;
            }
            if (Instantiator.class.isAssignableFrom(registeredType)) {
                return INSTANTIATOR;
            }
            if (Destructor.class.isAssignableFrom(registeredType)) {
                return DESTRUCTOR;
            }
            throw new AssertionError((Object)("Unable to determine registered Type from " + registeredType.getName()));
        }
    }

    private static class RegistryValue {
        Configurator<?, ?> configurator;
        Instantiator<?, ?> instantiator;
        Destructor<?> destructor;

        private RegistryValue() {
        }

        public RegistryValue setConfigurator(Configurator<?, ?> configurator) {
            this.configurator = configurator;
            return this;
        }

        public RegistryValue setInstantiator(Instantiator<?, ?> instantiator) {
            this.instantiator = instantiator;
            return this;
        }

        public RegistryValue setDestructor(Destructor<?> destructor) {
            this.destructor = destructor;
            return this;
        }
    }
}

