/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.saucelabs.extension.connect;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.lang3.SystemUtils;
import org.arquillian.drone.saucelabs.extension.connect.SauceConnectException;
import org.arquillian.drone.saucelabs.extension.utils.BinaryUrlUtils;
import org.arquillian.drone.saucelabs.extension.utils.Utils;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.archive.UntarTool;
import org.arquillian.spacelift.task.archive.UnzipTool;
import org.arquillian.spacelift.task.net.DownloadTool;

public class SauceConnectRunner {
    private static Logger log = Logger.getLogger(SauceConnectRunner.class.getName());
    private static SauceConnectRunner sauceConnectRunner = null;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final File sauceConnectDirectory = new File("target" + File.separator + "sauceconnect");
    private final File sauceConnectFile = new File(this.sauceConnectDirectory.getPath() + File.separator + "sc/bin/sc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
    private Process sauceConnectBinary = null;

    private SauceConnectRunner() {
    }

    public static SauceConnectRunner getSauceConnectRunnerInstance() {
        if (sauceConnectRunner == null) {
            sauceConnectRunner = new SauceConnectRunner();
        }
        return sauceConnectRunner;
    }

    public void runSauceConnect(String username, String accessKey, String additionalArgs, String localBinary) throws SauceConnectException {
        if (this.sauceConnectBinary != null) {
            return;
        }
        if (Utils.isNullOrEmpty(localBinary)) {
            if (!this.sauceConnectFile.exists()) {
                this.prepareSauceConnect();
            }
            this.runSauceConnect(this.sauceConnectFile, username, accessKey, additionalArgs);
        } else {
            this.runSauceConnect(new File(localBinary), username, accessKey, additionalArgs);
        }
    }

    private void runSauceConnect(File binaryFile, String username, String accessKey, String additionalArgs) throws SauceConnectException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(binaryFile.getAbsolutePath());
        args.add("-u");
        args.add(username);
        args.add("-k");
        args.add(accessKey);
        if (!Utils.isNullOrEmpty(additionalArgs)) {
            args.addAll(Arrays.asList(additionalArgs.split(" ")));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(args);
        try {
            this.sauceConnectBinary = processBuilder.start();
            Reader reader = new Reader();
            reader.start();
            Runtime.getRuntime().addShutdownHook(new ChildProcessCloser());
            this.countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new SauceConnectException("Running SauceConnect binary unexpectedly failed: ", e);
        }
    }

    private void prepareSauceConnect() {
        String url = BinaryUrlUtils.getPlatformBinaryNameUrl();
        String archiveName = url.substring(url.lastIndexOf("/") + 1);
        File sauceConnectArchiveFile = new File(this.sauceConnectDirectory.getPath() + File.separator + archiveName);
        log.info("Creating directory: " + this.sauceConnectDirectory);
        this.sauceConnectDirectory.mkdir();
        log.info("downloading zip file from: " + url + " into " + sauceConnectArchiveFile.getPath());
        ((DownloadTool)Spacelift.task(DownloadTool.class)).from(url).to(sauceConnectArchiveFile.getPath()).execute().await();
        if (archiveName.endsWith(".tar.gz")) {
            log.info("extracting tar file: " + sauceConnectArchiveFile + " into " + this.sauceConnectDirectory.getPath());
            ((UntarTool)Spacelift.task((Object)sauceConnectArchiveFile, UntarTool.class)).toDir(this.sauceConnectDirectory.getPath()).execute().await();
        } else {
            log.info("extracting zip file: " + sauceConnectArchiveFile + " into " + this.sauceConnectDirectory.getPath());
            ((UnzipTool)Spacelift.task((Object)sauceConnectArchiveFile, UnzipTool.class)).toDir(this.sauceConnectDirectory.getPath()).execute().await();
        }
        String fromDirectory = this.sauceConnectDirectory + File.separator + archiveName.replace(".zip", "").replace(".tar.gz", "");
        String toDirectory = this.sauceConnectDirectory + File.separator + "sc";
        log.info("renaming extracted directory: " + fromDirectory + " to: " + toDirectory);
        new File(fromDirectory).renameTo(new File(toDirectory));
        log.info("marking binary file: " + this.sauceConnectFile.getPath() + " as executable");
        try {
            this.sauceConnectFile.setExecutable(true);
        }
        catch (SecurityException se) {
            log.severe("The downloaded SauceConnect binary: " + this.sauceConnectFile + " could not be set as executable. This may cause additional problems.");
        }
    }

    private class ChildProcessCloser
    extends Thread {
        private ChildProcessCloser() {
        }

        @Override
        public void run() {
            SauceConnectRunner.this.sauceConnectBinary.destroy();
            try {
                SauceConnectRunner.this.sauceConnectBinary.waitFor();
            }
            catch (InterruptedException e) {
                throw new SauceConnectException("Stopping SauceConnect binary unexpectedly failed: ", e);
            }
        }
    }

    private class ProcessEndChecker
    implements Callable<Boolean> {
        private ProcessEndChecker() {
        }

        @Override
        public Boolean call() throws Exception {
            SauceConnectRunner.this.sauceConnectBinary.waitFor();
            return true;
        }
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(SauceConnectRunner.this.sauceConnectBinary.getInputStream()));
            boolean isAlreadyRunning = false;
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new ProcessEndChecker());
            Executors.newSingleThreadExecutor().submit(futureTask);
            while (!isAlreadyRunning) {
                try {
                    Process process = SauceConnectRunner.this.sauceConnectBinary;
                    synchronized (process) {
                        String line;
                        if (futureTask.isDone()) {
                            break;
                        }
                        while (in.ready() && (line = in.readLine()) != null) {
                            System.out.println("[SauceConnect]$ " + line);
                            if (SauceConnectRunner.this.countDownLatch.getCount() <= 0L) continue;
                            if (line.contains("Sauce Connect is up, you may start your tests")) {
                                SauceConnectRunner.this.countDownLatch.countDown();
                                continue;
                            }
                            if (!line.contains("check if Sauce Connect is already running")) continue;
                            isAlreadyRunning = true;
                            SauceConnectRunner.this.countDownLatch.countDown();
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    throw new SauceConnectException("Reading SauceConnect binary output unexpectedly failed: ", e);
                }
            }
        }
    }
}

