/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.saucelabs.extension.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.apache.commons.lang3.SystemUtils;
import org.arquillian.drone.saucelabs.extension.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class BinaryUrlUtils {
    private static final Logger log = Logger.getLogger(BinaryUrlUtils.class.getName());

    public static String getPlatformBinaryNameUrl() {
        String basicStaticUrl = "https://saucelabs.com/downloads/sc-4.3.13-";
        String parsedUrl = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            parsedUrl = BinaryUrlUtils.getUrl("win32");
            return Utils.isNullOrEmpty(parsedUrl) ? basicStaticUrl + "win32.zip" : parsedUrl;
        }
        if (SystemUtils.IS_OS_UNIX) {
            if (Utils.is64()) {
                parsedUrl = BinaryUrlUtils.getUrl("linux");
                return Utils.isNullOrEmpty(parsedUrl) ? basicStaticUrl + "linux.tar.gz" : parsedUrl;
            }
            parsedUrl = BinaryUrlUtils.getUrl("linux32");
            return Utils.isNullOrEmpty(parsedUrl) ? basicStaticUrl + "linux32.tar.gz" : parsedUrl;
        }
        if (SystemUtils.IS_OS_MAC) {
            parsedUrl = BinaryUrlUtils.getUrl("osx");
            return Utils.isNullOrEmpty(parsedUrl) ? basicStaticUrl + "osx.zip" : parsedUrl;
        }
        throw new IllegalStateException("The current platform is not supported.Supported platforms are windows, linux and macosx.Your platform has been detected as " + SystemUtils.OS_NAME);
    }

    private static String getUrl(String platform) {
        JSONObject json = null;
        try {
            json = BinaryUrlUtils.readJsonFromUrl("https://saucelabs.com/versions.json");
            return json.getJSONObject("Sauce Connect").getJSONObject(platform).getString("download_url");
        }
        catch (Exception e) {
            log.info("The url for downloading SauceConnect library wasn't successfully parsed from the https://saucelabs.com/versions.json. There will be used a static url with the version 4.3.13");
            return null;
        }
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readJsonFromUrl(String url) throws IOException, JSONException {
        InputStream is = new URL(url).openStream();
        BufferedReader rd = null;
        try {
            JSONObject json;
            rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = BinaryUrlUtils.readAll(rd);
            JSONObject jSONObject = json = new JSONObject(jsonText);
            return jSONObject;
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception ex) {
                    log.warning("There has been thrown an exception during closing a BufferedReader, that was reading from the Sauce Connect versions website: " + ex.getMessage());
                }
                finally {
                    rd = null;
                }
            }
        }
    }
}

