/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.saucelabs.extension.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SauceLabsDriver
extends RemoteWebDriver {
    private static final Logger log = Logger.getLogger(SauceLabsDriver.class.getName());
    private final boolean isSetSauceConnectManaged;

    public SauceLabsDriver(URL url, Capabilities capabilities, boolean isSetSauceConnectManaged) {
        super(url, capabilities);
        this.isSetSauceConnectManaged = isSetSauceConnectManaged;
    }

    public void get(String url) {
        String host = null;
        try {
            host = new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            log.warning("The url " + url + " has been detected as a malformed URL. The message of the exception: " + e.getMessage());
        }
        if (host != null && (host.equals("localhost") || host.equals("127.0.0.1")) && !this.isSetSauceConnectManaged) {
            log.info("To test against localhost and other locations behind your firewall, you need to use Sauce Connect. You can ignore this if you have already started it, otherwise see saucelabs.com/connect");
        }
        super.get(url);
    }
}

