/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.saucelabs.extension.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.arquillian.drone.saucelabs.extension.connect.SauceConnectRunner;
import org.arquillian.drone.saucelabs.extension.utils.Utils;
import org.arquillian.drone.saucelabs.extension.webdriver.SauceLabsDriver;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilitiesRegistry;
import org.openqa.selenium.Capabilities;

public class SauceLabsDriverFactory
implements Configurator<SauceLabsDriver, WebDriverConfiguration>,
Instantiator<SauceLabsDriver, WebDriverConfiguration>,
Destructor<SauceLabsDriver> {
    private static final Logger log = Logger.getLogger(SauceLabsDriverFactory.class.getName());
    @Inject
    private Instance<BrowserCapabilitiesRegistry> registryInstance;

    public WebDriverConfiguration createConfiguration(ArquillianDescriptor arquillianDescriptor, DronePoint<SauceLabsDriver> dronePoint) {
        BrowserCapabilitiesRegistry registry = (BrowserCapabilitiesRegistry)this.registryInstance.get();
        BrowserCapabilities browser = registry.getEntryFor("saucelabs");
        WebDriverConfiguration configuration = new WebDriverConfiguration(browser).configure(arquillianDescriptor, dronePoint.getQualifier());
        return configuration;
    }

    public void destroyInstance(SauceLabsDriver sauceLabsDriver) {
        sauceLabsDriver.quit();
    }

    public SauceLabsDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = configuration.getCapabilities();
        String url = (String)capabilities.getCapability("url");
        String username = null;
        String accessKey = null;
        if (Utils.isNullOrEmpty(url)) {
            username = (String)capabilities.getCapability("username");
            accessKey = (String)capabilities.getCapability("access.key");
            if (accessKey == null) {
                accessKey = (String)capabilities.getCapability("automate.key");
            }
            if (Utils.isNullOrEmpty(username) || Utils.isNullOrEmpty(accessKey)) {
                throw new IllegalArgumentException("You have to specify either an username and an access.key or the whole url in your arquillian descriptor");
            }
            url = "http://" + username + ":" + accessKey + "@ondemand.saucelabs.com:80/wd/hub";
        }
        try {
            URL sauceConnectUrl = new URL(url);
            boolean isSetSauceConnectManaged = capabilities.is("sauce.connect.managed");
            if (isSetSauceConnectManaged) {
                if (Utils.isNullOrEmpty(accessKey)) {
                    username = url.substring(url.lastIndexOf("://") + 3, url.indexOf(":"));
                    accessKey = url.substring(url.lastIndexOf(":") + 1, url.indexOf("@"));
                }
                String additionalArgs = (String)capabilities.getCapability("sauce.connect.args");
                String localBinary = (String)capabilities.getCapability("sauce.connect.binary");
                SauceConnectRunner.getSauceConnectRunnerInstance().runSauceConnect(username, accessKey, additionalArgs, localBinary);
            }
            return new SauceLabsDriver(sauceConnectUrl, capabilities, isSetSauceConnectManaged);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The BrowserStack url: " + url + " has been detected as a malformed URL. ", e);
        }
    }

    public int getPrecedence() {
        return 0;
    }
}

