/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.utils.GitHubLastUpdateCache;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.Rfc2126DateTimeFormatter;

public abstract class GitHubSource
implements ExternalBinarySource {
    private static final String LATEST_URL = "/releases/latest";
    private static final String RELEASES_URL = "/releases";
    private static final Logger log = Logger.getLogger(GitHubSource.class.toString());
    private static final Gson gson = new Gson();
    private static final String HEADER_X_RATELIMIT_RESET = "X-RateLimit-Reset";
    private static final String HEADER_X_RATELIMIT_REMAINING = "X-RateLimit-Remaining";
    private final HttpClient httpClient;
    private final GitHubLastUpdateCache cache;
    private final String projectUrl;
    private final String uniqueKey;
    private String tagNameKey = "tag_name";
    private String assetNameKey = "name";
    private String browserDownloadUrlKey = "browser_download_url";
    private String assetsKey = "assets";

    public GitHubSource(String organization, String project, HttpClient httpClient, GitHubLastUpdateCache gitHubLastUpdateCache) {
        this.httpClient = httpClient;
        this.projectUrl = String.format("https://api.github.com/repos/%s/%s", organization, project);
        this.uniqueKey = organization + "@" + project;
        this.cache = gitHubLastUpdateCache;
    }

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        HttpClient.Response response = this.sentGetRequestWithPagination(this.projectUrl + LATEST_URL, 1, this.lastModificationHeader());
        if (response.hasPayload()) {
            return this.processResponsePayload(response);
        }
        return this.cache.load(this.uniqueKey, ExternalBinary.class);
    }

    private ExternalBinary processResponsePayload(HttpClient.Response response) throws Exception {
        ExternalBinary binaryRelease;
        JsonElement jsonElement = (JsonElement)gson.fromJson(response.getPayload(), JsonElement.class);
        JsonObject latestRelease = jsonElement.getAsJsonObject();
        JsonElement tagNameElement = latestRelease.get(this.tagNameKey);
        if (tagNameElement == null) {
            binaryRelease = this.processEmptyResponse(response);
        } else {
            String tagName = tagNameElement.getAsString();
            binaryRelease = new ExternalBinary(tagName);
            binaryRelease.setUrl(this.findReleaseBinaryUrl(latestRelease, binaryRelease.getVersion()));
            this.cache.store(binaryRelease, this.uniqueKey, this.extractModificationDate(response));
        }
        return binaryRelease;
    }

    private ExternalBinary processEmptyResponse(HttpClient.Response response) throws Exception {
        StringBuffer msg = this.createErrorMessage(response, true);
        if (this.cache.cacheFileExists(this.uniqueKey)) {
            ExternalBinary binaryRelease = this.cache.load(this.uniqueKey, ExternalBinary.class);
            msg.append(" It will be used the cached version as the latest one: " + binaryRelease.getVersion());
            log.warning(msg.toString());
            return binaryRelease;
        }
        throw new IllegalStateException(msg.toString());
    }

    private StringBuffer createErrorMessage(HttpClient.Response response, boolean latest) {
        StringBuffer msg = new StringBuffer();
        if ("0".equals(response.getHeader(HEADER_X_RATELIMIT_REMAINING))) {
            msg.append("GitHub API rate limit exceeded. To get the information about the ");
            if (latest) {
                msg.append("latest ");
            }
            msg.append("release you need to wait till the rate limit is reset");
            try {
                Date resetTime = new Date(Long.valueOf(response.getHeader(HEADER_X_RATELIMIT_RESET)) * 1000L);
                msg.append(" which will be: " + resetTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            msg.append(".");
        } else {
            msg.append("There is some problem on GitHub server. It responded with: " + response.getPayload() + "\n");
        }
        return msg;
    }

    protected Map<String, String> lastModificationHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If-Modified-Since", this.cache.lastModificationOf(this.uniqueKey).withZoneSameInstant(ZoneId.of("GMT")).format(Rfc2126DateTimeFormatter.INSTANCE));
        return headers;
    }

    protected ZonedDateTime extractModificationDate(HttpClient.Response response) {
        String modificationDate = response.getHeader("Last-Modified");
        DateTimeFormatter dateTimeFormatter = Rfc2126DateTimeFormatter.INSTANCE;
        return ZonedDateTime.parse(modificationDate, dateTimeFormatter);
    }

    @Override
    public ExternalBinary getReleaseForVersion(String version) throws Exception {
        String url = this.projectUrl + RELEASES_URL;
        int pageNumber = 1;
        ArrayList<String> availableVersions = new ArrayList<String>();
        JsonElement releases = this.getReleasesJson(url, pageNumber);
        while (this.containsSubElements(releases)) {
            ExternalBinary releaseForVersion = this.getReleaseForVersion(version, releases.getAsJsonArray(), availableVersions);
            if (releaseForVersion != null) {
                return releaseForVersion;
            }
            releases = this.getReleasesJson(url, ++pageNumber);
        }
        if (availableVersions.isEmpty()) {
            throw new IllegalStateException(this.createErrorMessage(this.sentGetRequestWithPagination(url, 1, Collections.emptyMap()), false).toString());
        }
        throw new IllegalArgumentException("No release matching version " + version + " has been found in the repository " + this.projectUrl + " Available versions are: " + availableVersions + ".");
    }

    private boolean containsSubElements(JsonElement releases) {
        return releases != null && releases.isJsonArray() && releases.getAsJsonArray().size() > 0;
    }

    private JsonElement getReleasesJson(String url, int pageNumber) throws Exception {
        HttpClient.Response response = this.sentGetRequestWithPagination(url, pageNumber, Collections.emptyMap());
        return (JsonElement)gson.fromJson(response.getPayload(), JsonElement.class);
    }

    private ExternalBinary getReleaseForVersion(String version, JsonArray releases, List<String> availableVersions) throws Exception {
        for (JsonElement release : releases) {
            JsonObject releaseObject = release.getAsJsonObject();
            String releaseTagName = releaseObject.get(this.tagNameKey).getAsString();
            if (version.equals(releaseTagName)) {
                ExternalBinary binaryRelease = new ExternalBinary(releaseTagName);
                binaryRelease.setUrl(this.findReleaseBinaryUrl(releaseObject, binaryRelease.getVersion()));
                return binaryRelease;
            }
            availableVersions.add(releaseTagName);
        }
        return null;
    }

    protected String findReleaseBinaryUrl(JsonObject releaseObject, String version) throws Exception {
        JsonArray assets = releaseObject.get(this.assetsKey).getAsJsonArray();
        for (JsonElement asset : assets) {
            JsonObject assetJson = asset.getAsJsonObject();
            String name = assetJson.get(this.assetNameKey).getAsString();
            if (!name.matches(this.getFileNameRegexToDownload(version))) continue;
            return assetJson.get(this.browserDownloadUrlKey).getAsString();
        }
        return null;
    }

    protected HttpClient.Response sentGetRequestWithPagination(String url, int pageNumber, Map<String, String> headers) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (pageNumber != 1) {
            uriBuilder.setParameter("page", String.valueOf(pageNumber));
        }
        return this.httpClient.get(uriBuilder.build().toString(), headers);
    }

    protected String getProjectUrl() {
        return this.projectUrl;
    }

    protected Gson getGson() {
        return gson;
    }

    protected String getUniqueKey() {
        return this.uniqueKey;
    }

    protected GitHubLastUpdateCache getCache() {
        return this.cache;
    }
}

