/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.ChromeDriverBinaryHandler;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.jboss.arquillian.drone.webdriver.window.Dimensions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverFactory
extends AbstractWebDriverFactory<ChromeDriver>
implements Configurator<ChromeDriver, WebDriverConfiguration>,
Instantiator<ChromeDriver, WebDriverConfiguration>,
Destructor<ChromeDriver> {
    private static final Logger log = Logger.getLogger(ChromeDriverFactory.class.getName());
    public static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Chrome().getReadableName();
    public static final String HEADLESS_BROWSER_CAPABILITIES = new BrowserCapabilitiesList.ChromeHeadless().getReadableName();
    private static final String CHROME_PRINT_OPTIONS = "chromePrintOptions";

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(ChromeDriver instance) {
        instance.quit();
    }

    public ChromeDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, ChromeDriver.class);
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String binary = (String)capabilities.getCapability("chrome.binary");
        new ChromeDriverBinaryHandler(capabilities).checkAndSetBinary(performValidations);
        if (Validate.nonEmpty(binary) && performValidations) {
            Validate.isExecutable(binary, "Chrome binary must point to an executable file, " + binary);
        }
        this.setChromeOptions(configuration, capabilities);
        return capabilities;
    }

    public void setChromeOptions(WebDriverConfiguration configuration, DesiredCapabilities capabilities) {
        ChromeOptions chromeOptions = new ChromeOptions();
        this.manageChromeHeadless(configuration, chromeOptions);
        CapabilitiesOptionsMapper.mapCapabilities(chromeOptions, capabilities, BROWSER_CAPABILITIES);
        String binary = (String)capabilities.getCapability("chrome.binary");
        if (Validate.nonEmpty(binary)) {
            chromeOptions.setBinary(binary);
        }
        capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        String printChromeOptions = (String)capabilities.getCapability(CHROME_PRINT_OPTIONS);
        if (Validate.nonEmpty(printChromeOptions) && Boolean.valueOf(printChromeOptions.trim()).booleanValue()) {
            try {
                StringBuffer chromeOptionsLog = new StringBuffer("\n");
                chromeOptionsLog.append("======== Chrome options =========").append("\n");
                chromeOptionsLog.append(chromeOptions.toJson().toString()).append("\n");
                chromeOptionsLog.append("===== End of Chrome options =====");
                log.info(chromeOptionsLog.toString());
            }
            catch (IOException e) {
                log.warning("Something bad happened during printing chrome options: ");
                log.warning(e.getMessage());
            }
        }
    }

    public void manageChromeHeadless(WebDriverConfiguration configuration, ChromeOptions chromeOptions) {
        String browser = configuration.getBrowser().toLowerCase();
        if (browser.equals(HEADLESS_BROWSER_CAPABILITIES)) {
            chromeOptions.addArguments(new String[]{"--headless"});
            Dimensions dimensions = new Dimensions(configuration);
            if (dimensions.isFullscreenSet()) {
                dimensions.setWidth(1366);
                dimensions.setHeight(768);
                log.info(String.format("Chrome Headless does not support fullscreen. Setting default window-size to %dx%d", dimensions.getWidth(), dimensions.getHeight()));
            }
            if (dimensions.areDimensionsPositive()) {
                chromeOptions.addArguments(new String[]{String.format("--window-size=%d,%d", dimensions.getWidth(), dimensions.getHeight())});
            }
        }
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }

    @Override
    public WebDriverConfiguration createConfiguration(ArquillianDescriptor descriptor, DronePoint<ChromeDriver> dronePoint) {
        DroneConfiguration configuration = super.createConfiguration(descriptor, (DronePoint)dronePoint);
        if (!configuration.isRemote()) {
            configuration.setRemote(true);
            log.log(Level.FINE, "Forcing ChromeDriver configuration to be remote-based.");
        }
        return configuration;
    }
}

