/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.util.Map;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.FirefoxDriverBinaryHandler;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.utils.FirefoxPrefsReader;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverFactory
extends AbstractWebDriverFactory<FirefoxDriver>
implements Configurator<FirefoxDriver, WebDriverConfiguration>,
Instantiator<FirefoxDriver, WebDriverConfiguration>,
Destructor<FirefoxDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Firefox().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(FirefoxDriver instance) {
        instance.quit();
    }

    public FirefoxDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, FirefoxDriver.class);
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        FirefoxProfile firefoxProfile;
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String binary = (String)capabilities.getCapability("firefox_binary");
        String profile = (String)capabilities.getCapability("firefox_profile");
        if (Validate.nonEmpty(binary) && performValidations) {
            Validate.isExecutable(binary, "Firefox binary does not point to a valid executable,  " + binary);
        }
        new FirefoxDriverBinaryHandler(capabilities).checkAndSetBinary(performValidations);
        if (Validate.nonEmpty(profile)) {
            if (performValidations) {
                Validate.isValidPath(profile, "Firefox profile does not point to a valid path " + profile);
            }
            firefoxProfile = new FirefoxProfile(new File(profile));
        } else {
            firefoxProfile = new FirefoxProfile();
        }
        Boolean nativeEvents = (Boolean)configuration.getCapabilities().getCapability("nativeEvents");
        if (!Validate.empty(nativeEvents)) {
            firefoxProfile.setEnableNativeEvents(nativeEvents.booleanValue());
        }
        capabilities.setCapability("firefox_profile", (Object)firefoxProfile);
        String firefoxExtensions = (String)capabilities.getCapability("firefoxExtensions");
        for (String extensionPath : StringUtils.tokenize(firefoxExtensions)) {
            firefoxProfile.addExtension(new File(extensionPath));
        }
        String userPreferences = (String)capabilities.getCapability("firefoxUserPreferences");
        if (Validate.nonEmpty(userPreferences)) {
            Validate.isValidPath(userPreferences, "User preferences does not point to a valid path " + userPreferences);
            for (Map.Entry<String, Object> preference : FirefoxPrefsReader.getPreferences(new File(userPreferences)).entrySet()) {
                String key = preference.getKey();
                Object value = preference.getValue();
                if (value instanceof Boolean) {
                    firefoxProfile.setPreference(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    firefoxProfile.setPreference(key, ((Integer)value).intValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                firefoxProfile.setPreference(key, (String)value);
            }
        }
        return capabilities;
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

