/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jboss.arquillian.drone.webdriver.utils.Constants;
import org.jboss.arquillian.drone.webdriver.utils.Rfc2126DateTimeFormatter;

public class GitHubLastUpdateCache {
    private static final String ASSET_PROPERTY = "asset";
    private static final String LAST_MODIFIED_PROPERTY = "lastModified";
    private static final File DEFAULT_CACHE_DIRECTORY = new File(Constants.ARQUILLIAN_DRONE_CACHE_DIRECTORY + File.separator + "gh_cache" + File.separator);
    private final Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<ZonedDateTime>(){}.getType(), (Object)new ZonedDateTimeConverter()).create();
    private final File cacheDirectory;

    public GitHubLastUpdateCache(File cacheDirectory) {
        this.cacheDirectory = this.createCacheDirectory(cacheDirectory);
    }

    public GitHubLastUpdateCache() {
        this(DEFAULT_CACHE_DIRECTORY);
    }

    private File createCacheDirectory(File cacheDirectory) {
        if (cacheDirectory.exists() && !cacheDirectory.isDirectory()) {
            throw new IllegalArgumentException("Passed [" + cacheDirectory.getAbsolutePath() + "] exists and is not a directory.");
        }
        if (!cacheDirectory.exists() && !cacheDirectory.mkdirs()) {
            throw new RuntimeException("Could not create cache directory: " + cacheDirectory);
        }
        return cacheDirectory;
    }

    public ZonedDateTime lastModificationOf(String uniqueKey) {
        ZonedDateTime lastModification;
        if (this.cacheFileExists(uniqueKey)) {
            JsonElement lastModificationDate = this.deserializeCachedFile(uniqueKey).get(LAST_MODIFIED_PROPERTY);
            lastModification = (ZonedDateTime)this.gson.fromJson(lastModificationDate, ZonedDateTime.class);
        } else {
            lastModification = ZonedDateTime.of(2008, 4, 10, 0, 0, 0, 0, ZoneId.of("GMT"));
        }
        return lastModification;
    }

    public <T> T load(String uniqueKey, Class<T> type) {
        JsonObject asset = this.deserializeCachedFile(uniqueKey).getAsJsonObject(ASSET_PROPERTY);
        return (T)this.gson.fromJson((JsonElement)asset, type);
    }

    public boolean cacheFileExists(String uniqueKey) {
        return Files.exists(Paths.get(this.createCachedFilePath(uniqueKey), new String[0]), new LinkOption[0]);
    }

    public <T> void store(T asset, String uniqueKey, ZonedDateTime dateTime) {
        String cachedFilePath = this.createCachedFilePath(uniqueKey);
        JsonObject jsonObject = this.combineAsJson(asset, dateTime);
        try (FileOutputStream fileOutputStream = new FileOutputStream(cachedFilePath, false);){
            fileOutputStream.write(jsonObject.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to store " + jsonObject + "%n as [" + cachedFilePath + "]", e);
        }
    }

    private String createCachedFilePath(String uniqueKey) {
        return this.cacheDirectory.getAbsolutePath() + "/gh.cache." + uniqueKey + ".json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject deserializeCachedFile(String uniqueKey) {
        String cachedFilePath = this.createCachedFilePath(uniqueKey);
        try (FileReader reader = new FileReader(cachedFilePath);){
            JsonObject jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize file [" + cachedFilePath + "]", e);
        }
    }

    private <T> JsonObject combineAsJson(T asset, ZonedDateTime dateTime) {
        JsonElement assetAsJson = this.gson.toJsonTree(asset);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(LAST_MODIFIED_PROPERTY, this.gson.toJsonTree((Object)dateTime));
        jsonObject.add(ASSET_PROPERTY, assetAsJson);
        return jsonObject;
    }

    private static class ZonedDateTimeConverter
    implements JsonSerializer<ZonedDateTime>,
    JsonDeserializer<ZonedDateTime> {
        private static final DateTimeFormatter FORMATTER = Rfc2126DateTimeFormatter.INSTANCE;

        private ZonedDateTimeConverter() {
        }

        public JsonElement serialize(ZonedDateTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(FORMATTER.format(src));
        }

        public ZonedDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ZonedDateTime.parse(json.getAsString(), FORMATTER);
        }
    }
}

