/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.GitHubSource;
import org.jboss.arquillian.drone.webdriver.utils.GitHubLastUpdateCache;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.PlatformUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSGitHubBitbucketSource
extends GitHubSource {
    private static String BASE_DOWNLOAD_URL = "https://bitbucket.org/ariya/phantomjs/downloads/";
    private static String lastPhantomJSRelease = "2.1.1";

    public PhantomJSGitHubBitbucketSource(HttpClient httpClient, GitHubLastUpdateCache gitHubLastUpdateCache, DesiredCapabilities capabilities) {
        super("ariya", "phantomjs", httpClient, gitHubLastUpdateCache, capabilities);
    }

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        ExternalBinary lastPhantomJSVersion = new ExternalBinary(lastPhantomJSRelease);
        lastPhantomJSVersion.setUrl(this.getUrlForVersion(lastPhantomJSRelease));
        return lastPhantomJSVersion;
    }

    @Override
    public ExternalBinary getReleaseForVersion(String version) throws Exception {
        ExternalBinary phantomJSBinary = new ExternalBinary(version);
        phantomJSBinary.setUrl(this.getUrlForVersion(version));
        return phantomJSBinary;
    }

    protected String getUrlForVersion(String version) {
        return BASE_DOWNLOAD_URL + this.getFileNameRegexToDownload(version);
    }

    @Override
    public String getFileNameRegexToDownload(String version) {
        StringBuilder phantomFilenameZip = new StringBuilder("phantomjs-");
        phantomFilenameZip.append(version).append("-");
        if (PlatformUtils.isMac()) {
            phantomFilenameZip.append("macosx.zip").toString();
        } else if (PlatformUtils.isWindows()) {
            phantomFilenameZip.append("windows.zip");
        } else {
            phantomFilenameZip.append("linux-");
            if (PlatformUtils.is32()) {
                phantomFilenameZip.append("i686.tar.bz2").toString();
            } else {
                phantomFilenameZip.append("x86_64.tar.bz2").toString();
            }
        }
        return phantomFilenameZip.toString();
    }
}

