/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.input.BOMInputStream;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.MissingBinaryException;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class XmlStorageSource
implements ExternalBinarySource {
    private Logger log = Logger.getLogger(XmlStorageSource.class.toString());
    private HttpClient httpClient;
    protected String nodeName;
    protected String fileName;
    protected String urlToLatestRelease;
    private String storageUrl;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String latestVersion;

    public XmlStorageSource(String nodeName, String fileName, String storageUrl, String urlToLatestRelease, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.nodeName = nodeName;
        this.fileName = fileName;
        this.storageUrl = storageUrl;
        this.urlToLatestRelease = urlToLatestRelease;
    }

    public XmlStorageSource(String storageUrl, HttpClient httpClient) {
        this("Contents", "Key", storageUrl, null, httpClient);
    }

    public XmlStorageSource(String storageUrl, String urlToLatestRelease, HttpClient httpClient) {
        this("Contents", "Key", storageUrl, urlToLatestRelease, httpClient);
    }

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        return this.getLatestRelease("UTF-8");
    }

    protected ExternalBinary getLatestRelease(String charset) throws Exception {
        if (this.urlToLatestRelease != null) {
            this.latestVersion = this.getVersion(this.urlToLatestRelease, charset);
        }
        return this.getReleaseForVersion(this.latestVersion);
    }

    protected String getVersion(String versionUrl, String charset) throws IOException {
        return StringUtils.trimMultiline(this.httpClient.get(versionUrl, charset).getPayload());
    }

    private List<DriverEntry> retrieveAllDriversEntries() throws Exception {
        ArrayList<DriverEntry> results = new ArrayList<DriverEntry>();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setByteStream((InputStream)new BOMInputStream((InputStream)new ByteArrayInputStream(this.httpClient.get(this.storageUrl).getPayload().getBytes(StandardCharsets.UTF_8))));
        Document doc = db.parse(is);
        NodeList contentNodes = this.getDriverEntries(doc);
        for (int i = 0; i < contentNodes.getLength(); ++i) {
            Element driverNode = (Element)contentNodes.item(i);
            DriverEntry driverEntry = new DriverEntry();
            String key = this.getContentOfFirstElement(driverNode, this.fileName);
            if (!key.contains("/")) continue;
            driverEntry.setKey(key);
            driverEntry.setLastModified(this.getLastModified(driverNode));
            driverEntry.setLocation(this.getLocation(driverNode));
            results.add(driverEntry);
        }
        return results;
    }

    protected NodeList getDriverEntries(Document doc) {
        return ((Element)doc.getFirstChild()).getElementsByTagName(this.nodeName);
    }

    protected String getLastModified(Element element) {
        return this.getContentOfFirstElement(element, "LastModified");
    }

    protected String getLocation(Element element) {
        String key = this.getContentOfFirstElement(element, this.fileName);
        return key.substring(0, key.indexOf("/"));
    }

    private Date parseDate(String date, String key) {
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            this.log.warning("Date " + date + " of content " + this.storageUrl + key + " could not have been parsed. This content will be omitted. See the exception msg: " + e.getMessage());
            return null;
        }
    }

    protected String getContentOfFirstElement(Element element, String tagName) {
        NodeList elementsByTagName = element.getElementsByTagName(tagName);
        if (elementsByTagName.getLength() == 0) {
            return "";
        }
        return elementsByTagName.item(0).getTextContent();
    }

    @Override
    public ExternalBinary getReleaseForVersion(String requiredVersion) throws Exception {
        List<DriverEntry> driverEntries = this.retrieveAllDriversEntries();
        List<DriverEntry> matched = driverEntries.stream().filter(driverEntry -> {
            String expectedKeyRegex = this.getExpectedKeyRegex(requiredVersion, driverEntry.getLocation());
            boolean matches = driverEntry.getKey().matches(expectedKeyRegex);
            return matches;
        }).collect(Collectors.toList());
        if (matched.size() == 0) {
            throw new MissingBinaryException("There wasn't found any binary with the key matching regex " + this.getExpectedKeyRegex(requiredVersion, "directory") + " in the storage: " + this.storageUrl);
        }
        if (requiredVersion != null) {
            return new ExternalBinary(requiredVersion, this.storageUrl + matched.get(0).getKey());
        }
        DriverEntry latestDriverEntry = this.findLatestDriver(matched);
        return new ExternalBinary(latestDriverEntry.getLocation(), this.storageUrl + latestDriverEntry.getKey());
    }

    private DriverEntry findLatestDriver(List<DriverEntry> matched) {
        return (DriverEntry)matched.stream().min((c1, c2) -> {
            Date c1Date = this.parseDate(c1.getLastModified(), c1.getKey());
            Date c2Date = this.parseDate(c2.getLastModified(), c2.getKey());
            if (c1Date == null) {
                return -1;
            }
            if (c2Date == null) {
                return 1;
            }
            return Long.compare(c2Date.getTime(), c1Date.getTime());
        }).get();
    }

    protected abstract String getExpectedKeyRegex(String var1, String var2);

    class DriverEntry {
        private String key;
        private String location;
        private String lastModified;

        DriverEntry() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }
}

