/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

public class PlatformUtils {
    private PlatformUtils() {
    }

    public static String getOS() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getARCH() {
        return System.getProperty("os.arch").toLowerCase();
    }

    public static boolean isWindows() {
        return PlatformUtils.getOS().contains("win");
    }

    public static boolean isMac() {
        return PlatformUtils.getOS().contains("mac");
    }

    public static boolean isMacIntel() {
        return PlatformUtils.isMac() && PlatformUtils.getARCH().contains("x86_64");
    }

    public static boolean isMacAppleSilicon() {
        return PlatformUtils.isMac() && PlatformUtils.getARCH().contains("aarch64");
    }

    public static boolean isLinux() {
        return PlatformUtils.getOS().contains("linux");
    }

    public static boolean isUnix() {
        String os = PlatformUtils.getOS();
        return os.contains("nix") || os.contains("nux") || os.contains("aix");
    }

    public static boolean isSolaris() {
        return PlatformUtils.getOS().contains("sunos");
    }

    public static boolean is64() {
        return PlatformUtils.getARCH().contains("64");
    }

    public static boolean is32() {
        return !PlatformUtils.is64();
    }

    public static Platform platform() {
        return new Platform(){

            @Override
            public OperatingSystem os() {
                if (PlatformUtils.isWindows()) {
                    return OperatingSystem.WINDOWS;
                }
                if (PlatformUtils.isUnix()) {
                    return OperatingSystem.UNIX;
                }
                if (PlatformUtils.isMac()) {
                    return OperatingSystem.MACOSX;
                }
                if (PlatformUtils.isSolaris()) {
                    return OperatingSystem.SOLARIS;
                }
                return OperatingSystem.UNKNOWN;
            }

            @Override
            public Architecture arch() {
                return PlatformUtils.is64() ? Architecture.BIT64 : Architecture.BIT32;
            }
        };
    }

    public static interface Platform {
        public OperatingSystem os();

        public Architecture arch();
    }

    public static enum Architecture {
        BIT64,
        BIT32;

    }

    public static enum OperatingSystem {
        WINDOWS,
        UNIX,
        MACOSX,
        SOLARIS,
        UNKNOWN;

    }
}

