/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.augmentation;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.spi.DroneInstanceEnhancer;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriver;
import org.jboss.arquillian.drone.webdriver.spi.DroneAugmented;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;

public class AugmentingEnhancer
implements DroneInstanceEnhancer<RemoteWebDriver> {
    public static final String DRONE_AUGMENTED = "droneAugmented";
    private static final Logger logger = Logger.getLogger(AugmentingEnhancer.class.getName());
    private static final Augmenter augmenter = new Augmenter().addDriverAugmentation("droneAugmented", DroneAugmented.class, (c, exe) -> () -> c.getCapability(DRONE_AUGMENTED));

    public int getPrecedence() {
        return 0;
    }

    public boolean canEnhance(InstanceOrCallableInstance instance, Class<?> droneType, Class<? extends Annotation> qualifier) {
        if (RemoteWebDriver.class == droneType || ReusableRemoteWebDriver.class == droneType) {
            return true;
        }
        Class<?> realInstanceClass = instance.asInstance(droneType).getClass();
        return RemoteWebDriver.class == realInstanceClass || ReusableRemoteWebDriver.class == realInstanceClass || DroneAugmented.class.isAssignableFrom(realInstanceClass);
    }

    public RemoteWebDriver enhance(RemoteWebDriver instance, Class<? extends Annotation> qualifier) {
        return (RemoteWebDriver)augmenter.augment((WebDriver)instance);
    }

    public RemoteWebDriver deenhance(RemoteWebDriver enhancedInstance, Class<? extends Annotation> qualifier) {
        if (enhancedInstance instanceof DroneAugmented) {
            RemoteWebDriver original = (RemoteWebDriver)((DroneAugmented)enhancedInstance).getWrapped();
            Capabilities capabilities = enhancedInstance.getCapabilities();
            if (capabilities != null) {
                ((MutableCapabilities)enhancedInstance.getCapabilities()).setCapability(DRONE_AUGMENTED, (Object)Boolean.FALSE);
            }
            return original;
        }
        return enhancedInstance;
    }
}

