/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.process;

import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.webdriver.binary.process.StartSeleniumServer;
import org.openqa.selenium.grid.Main;

public class SeleniumServerExecutor {
    private Logger log = Logger.getLogger(SeleniumServerExecutor.class.toString());

    public void startSeleniumServer(@Observes StartSeleniumServer startSeleniumServer) {
        String[] stringArray;
        int port = startSeleniumServer.getUrl().getPort();
        if (startSeleniumServer.getSeleniumServerArgs() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "standalone";
        } else {
            stringArray = startSeleniumServer.getSeleniumServerArgs().split("[,\\s]");
        }
        String[] seleniumServerArgs = stringArray;
        boolean isHub = "hub".equals(seleniumServerArgs[0]);
        Stream.Builder<String> builder = Stream.builder();
        Arrays.stream(seleniumServerArgs).forEach(builder::add);
        builder.add("--port").add(Integer.toString(port));
        if (!isHub) {
            builder.add("--selenium-manager").add("true").add("--enable-managed-downloads").add("true");
        }
        String[] allArgs = (String[])builder.build().toArray(String[]::new);
        this.log.info("Starting server with: " + Arrays.asList(allArgs));
        Main.main((String[])allArgs);
    }
}

