/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.configuration;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;

public class WebDriverConfiguration
implements DroneConfiguration<WebDriverConfiguration> {
    public static final String CONFIGURATION_NAME = "webdriver";
    public static final String DEFAULT_BROWSER_CAPABILITIES = new BrowserCapabilitiesList.HtmlUnit().getReadableName();
    public static final String DEFAULT_SELENIUM_SERVER_ARGS = "";
    private static final Logger log = Logger.getLogger(WebDriverConfiguration.class.getName());
    public static URL DEFAULT_REMOTE_URL;
    private int iePort;
    private URL remoteAddress;
    private String browser;
    private boolean remoteReusable;
    private boolean remote;
    private String seleniumServerArgs;
    private boolean reuseCookies;
    private String dimensions;
    private Map<String, Object> capabilityMap;
    private String _originalBrowser;
    private BrowserCapabilities _browser;

    public WebDriverConfiguration(BrowserCapabilities browser) {
        if (browser != null) {
            this._browser = browser;
            this.browser = this._originalBrowser = browser.getReadableName();
        }
    }

    public void setBrowserInternal(BrowserCapabilities browser) {
        if (browser != null) {
            this._browser = browser;
            this.browser = browser.getReadableName();
        }
    }

    public WebDriverConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        if (this._originalBrowser != null && !this._originalBrowser.equals(this.browser)) {
            log.log(Level.WARNING, "Arquillian configuration is specifying a Drone of type {0}, however test class specifically asked for {1}. As Drone cannot guarantee that those two are compatible, \"browser\" property will be set to {1}.", new Object[]{this.browser, this._originalBrowser});
            this.browser = this._originalBrowser;
        }
        return this;
    }

    public String getBrowserName() {
        if (this._browser != null) {
            return this._browser.getReadableName();
        }
        return this.browser;
    }

    @Deprecated
    public String getBrowser() {
        return this.getBrowserName();
    }

    public void setBrowserName(String browser) {
        this.browser = browser;
    }

    @Deprecated
    public void setBrowser(String browser) {
        this.setBrowserName(browser);
    }

    public Capabilities getCapabilities() {
        return new ImmutableCapabilities(this.capabilityMap);
    }

    public String getSeleniumServerArgs() {
        return this.seleniumServerArgs;
    }

    public void setSeleniumServerArgs(String seleniumServerArgs) {
        this.seleniumServerArgs = seleniumServerArgs;
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    public int getIePort() {
        return this.iePort;
    }

    public void setIePort(int iePort) {
        this.iePort = iePort;
    }

    public String getImplementationClass() {
        return this._browser.getImplementationClassName();
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(URL remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isRemoteReusable() {
        return this.remoteReusable;
    }

    public void setRemoteReusable(boolean remoteReusable) {
        this.remoteReusable = remoteReusable;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public boolean isReuseCookies() {
        return this.reuseCookies;
    }

    public void setReuseCookies(boolean reuseCookies) {
        this.reuseCookies = reuseCookies;
    }

    static {
        try {
            DEFAULT_REMOTE_URL = new URL("http://localhost:4444/wd/hub");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

