/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class InternetExplorerDriverFactory
extends AbstractWebDriverFactory<InternetExplorerDriver>
implements Configurator<InternetExplorerDriver, WebDriverConfiguration>,
Instantiator<InternetExplorerDriver, WebDriverConfiguration>,
Destructor<InternetExplorerDriver> {
    public static final int DEFAULT_INTERNET_EXPLORER_PORT = 0;
    private static final Logger log = Logger.getLogger(InternetExplorerDriverFactory.class.getName());
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.InternetExplorer().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(InternetExplorerDriver instance) {
        instance.quit();
    }

    public InternetExplorerDriver createInstance(WebDriverConfiguration configuration) {
        int port = configuration.getIePort();
        InternetExplorerDriverService service = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)new InternetExplorerDriverService.Builder().withLogOutput((OutputStream)System.out)).build();
        if (port == 0) {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{InternetExplorerDriverService.class, InternetExplorerOptions.class}, new Object[]{service, this.getOptions(configuration, true)}, InternetExplorerDriver.class);
        }
        log.log(Level.FINE, "Creating InternetExplorerDriver bound to port {0}", port);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Integer.TYPE}, new Object[]{port}, InternetExplorerDriver.class);
    }

    public Capabilities getOptions(WebDriverConfiguration configuration, boolean performValidations) {
        return new InternetExplorerOptions();
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

