/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.client;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.core.command.DumpDataCommand;
import org.jboss.arquillian.persistence.core.data.dump.DataDump;
import org.jboss.arquillian.persistence.core.exception.DatabaseDumpException;

public class DatabaseStateDumper {
    public void dump(@Observes DumpDataCommand dumpDataCommand) {
        DataDump dataDump = dumpDataCommand.getDumpData();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(dataDump.getPath()));
            writer.write(dataDump.getDataSet());
        }
        catch (Exception e) {
            throw new DatabaseDumpException("Unable to dump database state to " + dataDump.getPath(), e);
        }
        finally {
            dumpDataCommand.setResult(true);
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    throw new DatabaseDumpException("Unable to close writer.", e);
                }
            }
        }
    }
}

