/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.configuration;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.persistence.core.configuration.Configuration;
import org.jboss.arquillian.persistence.core.configuration.PropertiesSerializer;
import org.jboss.arquillian.persistence.core.configuration.SecurityActions;
import org.jboss.arquillian.persistence.core.exception.ConfigurationExportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationExporter<T extends Configuration> {
    private final T configuration;
    private final PropertiesSerializer propertiesSerializer;

    public ConfigurationExporter(T configuration) {
        this.configuration = configuration;
        this.propertiesSerializer = new PropertiesSerializer(((Configuration)configuration).getPrefix());
    }

    public void toProperties(OutputStream output) {
        try {
            this.serializeFieldsToProperties(output);
        }
        catch (Exception e) {
            throw new ConfigurationExportException("Unable to serialize persistence configuration to property file.", e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    throw new ConfigurationExportException("Unable to close stream after serialization of persistence configuration to property file.", e);
                }
            }
        }
    }

    private void serializeFieldsToProperties(OutputStream output) throws IOException, IllegalArgumentException, IllegalAccessException {
        output.write(this.propertiesSerializer.serializeToProperties(this.mapFieldsToProperties()).toByteArray());
    }

    private Map<String, String> mapFieldsToProperties() throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, String> extractedValues = new HashMap<String, String>();
        List<Field> fields = SecurityActions.getAccessibleFields(this.configuration.getClass());
        for (Field field : fields) {
            Object object = field.get(this.configuration);
            String key = this.decamelize(field.getName());
            if (object == null) continue;
            extractedValues.put(key, this.convertToPropertyValue(object));
        }
        return extractedValues;
    }

    private String convertToPropertyValue(Object object) {
        String convertedValue = object instanceof Class ? ((Class)object).getName() : object.toString();
        if (String[].class.isInstance(object)) {
            convertedValue = Arrays.toString((String[])object);
            convertedValue = convertedValue.replace("[", "").replace("]", "").replace(", ", ",");
        }
        return convertedValue;
    }

    private String decamelize(String key) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('.').append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

