/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.configuration;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.persistence.core.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationTypeConverter {
    ConfigurationTypeConverter() {
    }

    public Class<?> box(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Unknown primitive type " + primitive);
    }

    public <T> T convert(String value, Class<T> to) {
        if (Strings.isEmpty(value) && !String.class.equals(to) && !String[].class.equals(to)) {
            return null;
        }
        if (String.class.equals(to)) {
            return to.cast(value);
        }
        if (Integer.class.equals(to)) {
            return to.cast(Integer.valueOf(value));
        }
        if (Double.class.equals(to)) {
            return to.cast(Double.valueOf(value));
        }
        if (Long.class.equals(to)) {
            return to.cast(Long.valueOf(value));
        }
        if (Boolean.class.equals(to)) {
            return to.cast(Boolean.valueOf(value));
        }
        if (URL.class.equals(to)) {
            try {
                return to.cast(new URI(value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (URI.class.equals(to)) {
            try {
                return to.cast(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        String trimmedValue = this.extractEnumName(value);
        if (to.isEnum()) {
            T enumInstance = Enum.valueOf(to, trimmedValue.toUpperCase());
            return enumInstance;
        }
        if (String[].class.equals(to)) {
            String[] convertedArray = value.split(",");
            if (convertedArray.length == 0) {
                return to.cast(new String[0]);
            }
            this.trimElements(convertedArray);
            if (convertedArray.length == 1 && this.hasOnlyBlanks(convertedArray)) {
                return to.cast(new String[0]);
            }
            return to.cast(convertedArray);
        }
        if (Class.class.equals(to)) {
            try {
                Class<?> clazz = Class.forName(value);
                return to.cast(clazz);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to find class [" + value + "].", e);
            }
        }
        try {
            Object instance = Class.forName(value).newInstance();
            return to.cast(instance);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert value [" + value + "] to a class [" + to.getName() + "].", e);
        }
    }

    private String extractEnumName(String value) {
        boolean potentiallyFullyQualifiedEnumName;
        String trimmedValue = value.trim();
        int lastDot = trimmedValue.lastIndexOf(46);
        boolean bl = potentiallyFullyQualifiedEnumName = lastDot > 0 && trimmedValue.length() > 1;
        if (potentiallyFullyQualifiedEnumName) {
            trimmedValue = trimmedValue.substring(lastDot + 1);
        }
        return trimmedValue;
    }

    private void trimElements(String[] convertedArray) {
        if (convertedArray == null) {
            return;
        }
        for (int i = 0; i < convertedArray.length; ++i) {
            convertedArray[i] = convertedArray[i].trim();
        }
    }

    private boolean hasOnlyBlanks(String[] convertedArray) {
        boolean hasOnlyBlanks = true;
        for (String element : convertedArray) {
            if (!this.isBlank(element)) continue;
            return false;
        }
        return hasOnlyBlanks;
    }

    private boolean isBlank(String element) {
        return element.trim().length() != 0;
    }
}

