/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.configuration;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.arquillian.container.test.api.Testable;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceDescriptorExtractor {
    private static final String WAR_AND_JAR = ".*\\.war|.*\\.jar";

    public InputStream getAsStream(Archive<?> archive) {
        Archive<?> testable = this.findTestableArchive(archive);
        Collection<Node> values = this.collectPersistenceXml(testable);
        if (values.size() == 1) {
            return values.iterator().next().getAsset().openStream();
        }
        return null;
    }

    private Archive<?> findTestableArchive(Archive<?> archive) {
        Map nestedArchives = archive.getContent(Filters.include((String)WAR_AND_JAR));
        if (!nestedArchives.isEmpty()) {
            for (ArchivePath path : nestedArchives.keySet()) {
                try {
                    GenericArchive genericArchive = (GenericArchive)archive.getAsType(GenericArchive.class, path);
                    if (!Testable.isArchiveToTest((Archive)genericArchive)) continue;
                    return genericArchive;
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
        return archive;
    }

    private Collection<Node> collectPersistenceXml(Archive<?> archive) {
        LinkedList<Node> nodes = new LinkedList<Node>(this.getPersistenceDescriptors(archive));
        for (Node node : this.collectSubArchives(archive)) {
            if (!(node.getAsset() instanceof ArchiveAsset)) continue;
            ArchiveAsset archiveAsset = (ArchiveAsset)node.getAsset();
            nodes.addAll(this.collectPersistenceXml(archiveAsset.getArchive()));
        }
        return nodes;
    }

    private Collection<Node> getPersistenceDescriptors(Archive<?> archive) {
        return archive.getContent(Filters.include((String)".*persistence.xml")).values();
    }

    private Collection<Node> collectSubArchives(Archive<?> archive) {
        return archive.getContent(Filters.include((String)WAR_AND_JAR)).values();
    }
}

