/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.configuration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.arquillian.persistence.core.exception.MultiplePersistenceUnitsException;
import org.jboss.arquillian.persistence.core.exception.PersistenceDescriptorParsingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistenceDescriptorParser {
    private static final String JTA_DATA_SOURCE_TAG = "jta-data-source";
    private static final String NON_JTA_DATA_SOURCE_TAG = "non-jta-data-source";
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public String obtainDataSourceName(String descriptor) {
        Document document = this.parseXmlDescriptor(descriptor);
        NodeList persistenceUnits = document.getElementsByTagName("persistence-unit");
        if (persistenceUnits.getLength() > 1) {
            throw new MultiplePersistenceUnitsException("Multiple persistence units defined. Please specify default data source either in 'arquillian.xml' or by using @DataSource annotation");
        }
        Node persistenceUnit = persistenceUnits.item(0);
        Node dataSource = this.getJtaDataSource(persistenceUnit);
        if (dataSource == null) {
            dataSource = this.getNonJtaDataSource(persistenceUnit);
        }
        return dataSource.getTextContent();
    }

    public String obtainDataSourceName(InputStream inputStream) {
        return this.obtainDataSourceName(new Scanner(inputStream).useDelimiter("\\A").next());
    }

    private Document parseXmlDescriptor(String descriptor) {
        Document document = null;
        try {
            document = this.factory.newDocumentBuilder().parse(new ByteArrayInputStream(descriptor.getBytes()));
        }
        catch (Exception e) {
            throw new PersistenceDescriptorParsingException("Unable to parse descriptor " + descriptor, e);
        }
        return document;
    }

    private Node getNonJtaDataSource(Node persistenceUnit) {
        return ((Element)persistenceUnit).getElementsByTagName(NON_JTA_DATA_SOURCE_TAG).item(0);
    }

    private Node getJtaDataSource(Node persistenceUnit) {
        return ((Element)persistenceUnit).getElementsByTagName(JTA_DATA_SOURCE_TAG).item(0);
    }
}

