/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.configuration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jboss.arquillian.persistence.core.exception.PersistenceExtensionInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesSerializer {
    private final String prefix;

    public PropertiesSerializer() {
        this("");
    }

    public PropertiesSerializer(String prefix) {
        this.prefix = prefix;
    }

    public ByteArrayOutputStream serializeToProperties(Map<String, String> properties) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                output.write(this.serializeAsProperty(entry).getBytes());
            }
        }
        catch (IOException e) {
            throw new PersistenceExtensionInitializationException("Unable to serialize dbunit properties", e);
        }
        return output;
    }

    private String serializeAsProperty(Map.Entry<String, String> entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix).append(entry.getKey()).append("=").append(entry.getValue().replace("\\", "\\\\")).append('\n');
        String serializedAsProperty = sb.toString();
        return serializedAsProperty;
    }
}

