/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.deployment;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.persistence.core.configuration.Configuration;
import org.jboss.arquillian.persistence.core.configuration.ConfigurationExporter;
import org.jboss.arquillian.persistence.core.configuration.PersistenceConfiguration;
import org.jboss.arquillian.persistence.core.configuration.PersistenceDescriptorExtractor;
import org.jboss.arquillian.persistence.core.configuration.PersistenceDescriptorParser;
import org.jboss.arquillian.persistence.core.configuration.PropertiesSerializer;
import org.jboss.arquillian.persistence.core.exception.MultiplePersistenceUnitsException;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionEnabler;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.jpa.cache.JpaCacheEvictionConfiguration;
import org.jboss.arquillian.persistence.script.ScriptLoader;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceExtensionConfigurationTestArchiveEnricher
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(PersistenceExtensionConfigurationTestArchiveEnricher.class.getName());
    @Inject
    Instance<PersistenceConfiguration> configurationInstance;
    @Inject
    Instance<DBUnitConfiguration> dbunitConfigurationInstance;
    @Inject
    Instance<ScriptingConfiguration> scriptingConfigurationInstance;
    @Inject
    Instance<ArquillianDescriptor> arquillianDescriptorInstance;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        PersistenceExtensionEnabler persistenceExtensionEnabler = new PersistenceExtensionEnabler(testClass);
        if (!persistenceExtensionEnabler.shouldPersistenceExtensionBeActivated()) {
            return;
        }
        this.obtainDataSourceFromPersistenceXml(applicationArchive);
        JavaArchive additionalPersistenceResources = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-persistence-extension-additional-resources.jar");
        this.merge(additionalPersistenceResources, this.sqlScriptsAsResource(((ScriptingConfiguration)this.scriptingConfigurationInstance.get()).getScriptsToExecuteAfterTest()), this.sqlScriptsAsResource(((ScriptingConfiguration)this.scriptingConfigurationInstance.get()).getScriptsToExecuteBeforeTest()), this.persistenceConfigurationSerializedAsProperties(), this.dbUnitConfigurationSerializedAsProperties(), this.scriptingConfigurationSerializedAsProperties(), this.jpaCacheEvictionConfigurationSerializedAsProperties());
        this.addResources(applicationArchive, additionalPersistenceResources);
    }

    private void obtainDataSourceFromPersistenceXml(Archive<?> applicationArchive) {
        if (((PersistenceConfiguration)this.configurationInstance.get()).isDefaultDataSourceDefined()) {
            return;
        }
        PersistenceDescriptorExtractor persistenceDescriptorArchiveExtractor = new PersistenceDescriptorExtractor();
        InputStream persistenceXmlAsStream = persistenceDescriptorArchiveExtractor.getAsStream(applicationArchive);
        if (persistenceXmlAsStream != null) {
            PersistenceDescriptorParser parser = new PersistenceDescriptorParser();
            try {
                String dataSourceName = parser.obtainDataSourceName(persistenceXmlAsStream);
                ((PersistenceConfiguration)this.configurationInstance.get()).setDefaultDataSource(dataSourceName);
            }
            catch (MultiplePersistenceUnitsException e) {
                log.info("Unable to deduct data source from test's archive persistence.xml. " + e.getMessage());
            }
        }
    }

    private void merge(JavaArchive target, JavaArchive ... archivesToMerge) {
        for (JavaArchive archiveToMerge : archivesToMerge) {
            target.merge((Archive)archiveToMerge);
        }
    }

    private JavaArchive persistenceConfigurationSerializedAsProperties() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource((Asset)new ByteArrayAsset(this.exportPersistenceConfigurationAsProperties().toByteArray()), ((PersistenceConfiguration)this.configurationInstance.get()).getPrefix() + "properties");
    }

    private ByteArrayOutputStream exportPersistenceConfigurationAsProperties() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ConfigurationExporter<Configuration> exporter = new ConfigurationExporter<Configuration>((Configuration)this.configurationInstance.get());
        exporter.toProperties(output);
        return output;
    }

    private JavaArchive dbUnitConfigurationSerializedAsProperties() {
        DBUnitConfiguration dbUnitConfigurationPrototype = new DBUnitConfiguration();
        Map<String, String> extensionProperties = this.extractExtensionProperties((ArquillianDescriptor)this.arquillianDescriptorInstance.get(), dbUnitConfigurationPrototype.getQualifier());
        ByteArrayOutputStream properties = new PropertiesSerializer(dbUnitConfigurationPrototype.getPrefix()).serializeToProperties(extensionProperties);
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource((Asset)new ByteArrayAsset(properties.toByteArray()), new DBUnitConfiguration().getPrefix() + "properties");
    }

    private JavaArchive scriptingConfigurationSerializedAsProperties() {
        ScriptingConfiguration scriptingConfigurationPrototype = new ScriptingConfiguration();
        Map<String, String> extensionProperties = this.extractExtensionProperties((ArquillianDescriptor)this.arquillianDescriptorInstance.get(), scriptingConfigurationPrototype.getQualifier());
        ByteArrayOutputStream properties = new PropertiesSerializer(scriptingConfigurationPrototype.getPrefix()).serializeToProperties(extensionProperties);
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource((Asset)new ByteArrayAsset(properties.toByteArray()), new ScriptingConfiguration().getPrefix() + "properties");
    }

    private JavaArchive jpaCacheEvictionConfigurationSerializedAsProperties() {
        JpaCacheEvictionConfiguration config = new JpaCacheEvictionConfiguration();
        Map<String, String> extensionProperties = this.extractExtensionProperties((ArquillianDescriptor)this.arquillianDescriptorInstance.get(), config.getQualifier());
        ByteArrayOutputStream output = new PropertiesSerializer(config.getPrefix()).serializeToProperties(extensionProperties);
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource((Asset)new ByteArrayAsset(output.toByteArray()), new JpaCacheEvictionConfiguration().getPrefix() + "properties");
    }

    private JavaArchive sqlScriptsAsResource(String ... scripts) {
        if (scripts == null) {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
        JavaArchive sqlScriptsArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        for (String script : scripts) {
            if (!ScriptLoader.isSqlScriptFile(script)) continue;
            sqlScriptsArchive.merge((Archive)this.createArchiveWithResources(script));
        }
        return sqlScriptsArchive;
    }

    private Map<String, String> extractExtensionProperties(ArquillianDescriptor descriptor, String qualifier) {
        HashMap<String, String> extensionProperties = new HashMap<String, String>();
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (!extension.getExtensionName().equals(qualifier)) continue;
            extensionProperties.putAll(extension.getExtensionProperties());
            break;
        }
        return extensionProperties;
    }

    private void addResources(Archive<?> applicationArchive, JavaArchive dataArchive) {
        if (JavaArchive.class.isInstance(applicationArchive)) {
            applicationArchive.merge((Archive)dataArchive);
        } else {
            LibraryContainer libraryContainer = (LibraryContainer)applicationArchive;
            libraryContainer.addAsLibrary((Archive)dataArchive);
        }
    }

    private JavaArchive createArchiveWithResources(String ... resourcePaths) {
        JavaArchive dataSetsArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        for (String path : resourcePaths) {
            dataSetsArchive.addAsResource(path);
        }
        return dataSetsArchive;
    }
}

