/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.persistence.ApplyScriptAfter;
import org.jboss.arquillian.persistence.ApplyScriptBefore;
import org.jboss.arquillian.persistence.CleanupUsingScript;
import org.jboss.arquillian.persistence.CreateSchema;
import org.jboss.arquillian.persistence.core.data.descriptor.ResourceDescriptor;
import org.jboss.arquillian.persistence.core.data.descriptor.TextFileResourceDescriptor;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionEnabler;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.data.descriptor.DataSetResourceDescriptor;
import org.jboss.arquillian.persistence.dbunit.data.descriptor.Format;
import org.jboss.arquillian.persistence.dbunit.data.provider.DataSetProvider;
import org.jboss.arquillian.persistence.dbunit.data.provider.ExpectedDataSetProvider;
import org.jboss.arquillian.persistence.dbunit.dataset.xml.DtdResolver;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.provider.SqlScriptProvider;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceExtensionDataResourcesTestArchiveEnricher
implements ApplicationArchiveProcessor {
    @Inject
    Instance<DBUnitConfiguration> dbunitConfigurationInstance;
    @Inject
    Instance<ScriptingConfiguration> scriptingConfigurationInstance;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        PersistenceExtensionEnabler persistenceExtensionEnabler = new PersistenceExtensionEnabler(testClass);
        if (!persistenceExtensionEnabler.shouldPersistenceExtensionBeActivated()) {
            return;
        }
        Set<ResourceDescriptor<?>> allDataResources = this.fetchAllDataResources(testClass);
        if (!allDataResources.isEmpty()) {
            this.addResources(applicationArchive, this.toJavaArchive(allDataResources));
        }
    }

    private void addResources(Archive<?> applicationArchive, JavaArchive dataArchive) {
        if (JavaArchive.class.isInstance(applicationArchive)) {
            applicationArchive.merge((Archive)dataArchive);
        } else {
            LibraryContainer libraryContainer = (LibraryContainer)applicationArchive;
            libraryContainer.addAsLibrary((Archive)dataArchive);
        }
    }

    private JavaArchive toJavaArchive(Collection<? extends ResourceDescriptor<?>> descriptors) {
        ArrayList<String> paths = new ArrayList<String>(descriptors.size());
        for (ResourceDescriptor<?> descriptor : descriptors) {
            paths.add(descriptor.getLocation());
        }
        return this.createArchiveWithResources(paths.toArray(new String[descriptors.size()]));
    }

    private Set<ResourceDescriptor<?>> fetchAllDataResources(TestClass testClass) {
        HashSet allDataSets = new HashSet();
        DataSetProvider dataSetProvider = new DataSetProvider(new MetadataExtractor(testClass), (DBUnitConfiguration)this.dbunitConfigurationInstance.get());
        ExpectedDataSetProvider expectedDataSetProvider = new ExpectedDataSetProvider(new MetadataExtractor(testClass), (DBUnitConfiguration)this.dbunitConfigurationInstance.get());
        SqlScriptProvider<ApplyScriptBefore> scriptsAppliedBeforeTestProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedBeforeTest(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        SqlScriptProvider<ApplyScriptAfter> scriptsAppliedAfterTestProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedAfterTest(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        SqlScriptProvider<CleanupUsingScript> cleanupScriptsProvider = SqlScriptProvider.createProviderForCleanupScripts(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        SqlScriptProvider<CreateSchema> createSchemaScripts = SqlScriptProvider.createProviderForCreateSchemaScripts(testClass, (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
        allDataSets.addAll(dataSetProvider.getDescriptors(testClass));
        allDataSets.addAll(expectedDataSetProvider.getDescriptors(testClass));
        allDataSets.addAll(this.extractDtds(dataSetProvider.getDescriptors(testClass)));
        allDataSets.addAll(this.extractDtds(expectedDataSetProvider.getDescriptors(testClass)));
        allDataSets.addAll(scriptsAppliedBeforeTestProvider.getDescriptors(testClass));
        allDataSets.addAll(scriptsAppliedAfterTestProvider.getDescriptors(testClass));
        allDataSets.addAll(cleanupScriptsProvider.getDescriptors(testClass));
        allDataSets.addAll(createSchemaScripts.getDescriptors(testClass));
        return allDataSets;
    }

    private Collection<TextFileResourceDescriptor> extractDtds(Collection<DataSetResourceDescriptor> descriptors) {
        ArrayList<TextFileResourceDescriptor> dtds = new ArrayList<TextFileResourceDescriptor>();
        DtdResolver dtdResolver = new DtdResolver();
        for (DataSetResourceDescriptor dataSet : descriptors) {
            String dtd;
            if (!Format.XML.equals((Object)dataSet.getFormat()) || (dtd = dtdResolver.resolveDtdLocationFullPath(dataSet.getLocation())) == null) continue;
            dtds.add(new TextFileResourceDescriptor(dtd));
        }
        return dtds;
    }

    private JavaArchive createArchiveWithResources(String ... resourcePaths) {
        JavaArchive dataSetsArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        for (String path : resourcePaths) {
            dataSetsArchive.addAsResource(path);
        }
        return dataSetsArchive;
    }
}

