/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.ApplyScriptsAfterTest;
import org.jboss.arquillian.persistence.core.event.ApplyScriptsBeforeTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.util.Strings;
import org.jboss.arquillian.persistence.script.ScriptLoader;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.descriptor.FileSqlScriptResourceDescriptor;
import org.jboss.arquillian.persistence.script.data.descriptor.InlineSqlScriptResourceDescriptor;
import org.jboss.arquillian.persistence.script.data.descriptor.SqlScriptResourceDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomScriptsExecutor {
    @Inject
    private Instance<ScriptingConfiguration> scriptingConfigurationInstance;
    @Inject
    private Event<ApplyScriptsBeforeTest> applyScriptsBeforeTestEvent;
    @Inject
    private Event<ApplyScriptsAfterTest> applyScriptsAfterTestEvent;

    public void executeBeforeTest(@Observes(precedence=50) BeforePersistenceTest beforePersistenceTest) {
        this.executeScriptsBeforeTest(beforePersistenceTest);
    }

    public void executeAfterTest(@Observes(precedence=10) AfterPersistenceTest afterPersistenceTest) {
        this.executeScriptsAfterTest(afterPersistenceTest);
    }

    private void executeScriptsBeforeTest(BeforePersistenceTest beforePersistenceTest) {
        ScriptingConfiguration configuration = (ScriptingConfiguration)this.scriptingConfigurationInstance.get();
        String[] scriptsToExecuteBeforeTest = configuration.getScriptsToExecuteBeforeTest();
        List<SqlScriptResourceDescriptor> scripts = this.processScripts(scriptsToExecuteBeforeTest);
        this.applyScriptsBeforeTestEvent.fire((Object)new ApplyScriptsBeforeTest(beforePersistenceTest, scripts));
    }

    private void executeScriptsAfterTest(AfterPersistenceTest afterPersistenceTest) {
        ScriptingConfiguration configuration = (ScriptingConfiguration)this.scriptingConfigurationInstance.get();
        String[] scriptsToExecuteAfterTest = configuration.getScriptsToExecuteAfterTest();
        List<SqlScriptResourceDescriptor> scripts = this.processScripts(scriptsToExecuteAfterTest);
        this.applyScriptsAfterTestEvent.fire((Object)new ApplyScriptsAfterTest(afterPersistenceTest, scripts));
    }

    private List<SqlScriptResourceDescriptor> processScripts(String[] scripts) {
        if (scripts == null) {
            return Collections.emptyList();
        }
        ArrayList<SqlScriptResourceDescriptor> processedScripts = new ArrayList<SqlScriptResourceDescriptor>();
        for (String script : scripts) {
            if (ScriptLoader.isSqlScriptFile(script)) {
                processedScripts.add(new FileSqlScriptResourceDescriptor(script));
                continue;
            }
            if (Strings.isEmpty(script)) continue;
            processedScripts.add(new InlineSqlScriptResourceDescriptor(script));
        }
        return processedScripts;
    }
}

