/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.lifecycle;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.CleanupUsingScript;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.event.CleanupData;
import org.jboss.arquillian.persistence.core.event.CleanupDataUsingScript;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionScriptingFeatureResolver;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.provider.SqlScriptProvider;

public class DataCleanupHandler {
    @Inject
    private Instance<ScriptingConfiguration> scriptingConfigurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;
    @Inject
    private Instance<PersistenceExtensionScriptingFeatureResolver> persistenceExtensionScriptingFeatureResolverInstance;
    @Inject
    private Event<CleanupData> cleanUpDataEvent;
    @Inject
    private Event<CleanupDataUsingScript> cleanUpDataUsingScriptEvent;

    public void prepareDatabase(@Observes(precedence=40) BeforePersistenceTest beforePersistenceTest) {
        if (((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).shouldCleanupBefore()) {
            this.cleanUpDataEvent.fire((Object)new CleanupData(beforePersistenceTest, ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).getCleanupStrategy()));
        }
        if (((PersistenceExtensionScriptingFeatureResolver)this.persistenceExtensionScriptingFeatureResolverInstance.get()).shouldCleanupUsingScriptBefore()) {
            SqlScriptProvider<CleanupUsingScript> scriptsProvider = SqlScriptProvider.createProviderForCleanupScripts(beforePersistenceTest.getTestClass(), (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
            this.cleanUpDataUsingScriptEvent.fire((Object)new CleanupDataUsingScript(scriptsProvider.getDescriptorsDefinedFor(beforePersistenceTest.getTestMethod())));
        }
    }

    public void verifyDatabase(@Observes(precedence=20) AfterPersistenceTest afterPersistenceTest) {
        if (((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).shouldCleanupAfter()) {
            this.cleanUpDataEvent.fire((Object)new CleanupData(afterPersistenceTest, ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).getCleanupStrategy()));
        }
        if (((PersistenceExtensionScriptingFeatureResolver)this.persistenceExtensionScriptingFeatureResolverInstance.get()).shouldCleanupUsingScriptAfter()) {
            SqlScriptProvider<CleanupUsingScript> scriptsProvider = SqlScriptProvider.createProviderForCleanupScripts(afterPersistenceTest.getTestClass(), (ScriptingConfiguration)this.scriptingConfigurationInstance.get());
            this.cleanUpDataUsingScriptEvent.fire((Object)new CleanupDataUsingScript(scriptsProvider.getDescriptorsDefinedFor(afterPersistenceTest.getTestMethod())));
        }
    }
}

