/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.lifecycle;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.ApplyScriptAfter;
import org.jboss.arquillian.persistence.ApplyScriptBefore;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.event.ExecuteScripts;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.provider.SqlScriptProvider;

public class DataScriptsHandler {
    @Inject
    private Instance<ScriptingConfiguration> configuration;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolver;
    @Inject
    private Event<ExecuteScripts> executeScriptsEvent;

    public void executeBeforeTest(@Observes(precedence=30) BeforePersistenceTest beforePersistenceTest) {
        this.executeCustomScriptsBefore(beforePersistenceTest);
    }

    public void executeAfterTest(@Observes(precedence=40) AfterPersistenceTest afterPersistenceTest) {
        this.executeCustomScriptsAfter(afterPersistenceTest);
    }

    private void executeCustomScriptsBefore(BeforePersistenceTest beforePersistenceTest) {
        if (!((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolver.get()).shouldCustomScriptBeAppliedBeforeTestRequested()) {
            return;
        }
        SqlScriptProvider<ApplyScriptBefore> scriptsProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedBeforeTest(beforePersistenceTest.getTestClass(), (ScriptingConfiguration)this.configuration.get());
        this.executeScriptsEvent.fire((Object)new ExecuteScripts(beforePersistenceTest, scriptsProvider.getDescriptorsDefinedFor(beforePersistenceTest.getTestMethod())));
    }

    private void executeCustomScriptsAfter(AfterPersistenceTest afterPersistenceTest) {
        if (!((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolver.get()).shouldCustomScriptBeAppliedAfterTestRequested()) {
            return;
        }
        SqlScriptProvider<ApplyScriptAfter> scriptsProvider = SqlScriptProvider.createProviderForScriptsToBeAppliedAfterTest(afterPersistenceTest.getTestClass(), (ScriptingConfiguration)this.configuration.get());
        this.executeScriptsEvent.fire((Object)new ExecuteScripts(afterPersistenceTest, scriptsProvider.getDescriptorsDefinedFor(afterPersistenceTest.getTestMethod())));
    }
}

