/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.lifecycle;

import java.lang.reflect.Method;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.ShouldMatchDataSet;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.event.CompareData;
import org.jboss.arquillian.persistence.core.event.PrepareData;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.data.provider.DataSetProvider;
import org.jboss.arquillian.persistence.dbunit.data.provider.ExpectedDataSetProvider;

public class DataSetHandler {
    @Inject
    private Instance<MetadataExtractor> metadataExtractorInstance;
    @Inject
    private Instance<DBUnitConfiguration> configurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;
    @Inject
    private Event<PrepareData> prepareDataEvent;
    @Inject
    private Event<CompareData> compareDataEvent;

    public void prepareDatabase(@Observes(precedence=20) BeforePersistenceTest beforePersistenceTest) {
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldSeedData()) {
            DataSetProvider dataSetProvider = new DataSetProvider((MetadataExtractor)this.metadataExtractorInstance.get(), (DBUnitConfiguration)this.configurationInstance.get());
            this.prepareDataEvent.fire((Object)new PrepareData(dataSetProvider.getDescriptorsDefinedFor(beforePersistenceTest.getTestMethod())));
        }
    }

    public void verifyDatabase(@Observes(precedence=30) AfterPersistenceTest afterPersistenceTest) {
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldVerifyDataAfterTest()) {
            MetadataExtractor metadataExtractor = (MetadataExtractor)this.metadataExtractorInstance.get();
            ExpectedDataSetProvider dataSetProvider = new ExpectedDataSetProvider(metadataExtractor, (DBUnitConfiguration)this.configurationInstance.get());
            Method testMethod = afterPersistenceTest.getTestMethod();
            ShouldMatchDataSet dataSetsToVerify = metadataExtractor.shouldMatchDataSet().fetchFrom(testMethod);
            this.compareDataEvent.fire((Object)new CompareData(dataSetProvider.getDescriptorsDefinedFor(testMethod), dataSetsToVerify.orderBy(), dataSetsToVerify.excludeColumns()));
        }
    }
}

