/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.lifecycle;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.core.configuration.PersistenceConfiguration;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceClass;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.event.InitializeConfiguration;
import org.jboss.arquillian.persistence.core.exception.ContextNotAvailableException;
import org.jboss.arquillian.persistence.core.exception.DataSourceNotFoundException;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionEnabler;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionScriptingFeatureResolver;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

public class PersistenceTestTrigger {
    @Inject
    @ClassScoped
    private InstanceProducer<MetadataExtractor> metadataExtractorProducer;
    @Inject
    @ClassScoped
    private InstanceProducer<PersistenceExtensionEnabler> persistenceExtensionEnabler;
    @Inject
    @TestScoped
    private InstanceProducer<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverProvider;
    @Inject
    @TestScoped
    private InstanceProducer<PersistenceExtensionScriptingFeatureResolver> persistenceExtensionScriptingFeatureResolverProvider;
    @Inject
    @TestScoped
    private InstanceProducer<DataSource> dataSourceProducer;
    @Inject
    private Instance<Context> contextInstance;
    @Inject
    private Instance<PersistenceConfiguration> configurationInstance;
    @Inject
    private Instance<ScriptingConfiguration> scriptingConfigurationInstance;
    @Inject
    private Event<BeforePersistenceTest> beforePersistenceTestEvent;
    @Inject
    private Event<AfterPersistenceTest> afterPersistenceTestEvent;
    @Inject
    private Event<InitializeConfiguration> initializeConfigurationEvent;
    @Inject
    private Event<BeforePersistenceClass> beforePersistenceClassEvent;

    public void beforeClass(@Observes BeforeClass beforeClass) {
        this.metadataExtractorProducer.set((Object)new MetadataExtractor(beforeClass.getTestClass()));
        this.persistenceExtensionEnabler.set((Object)new PersistenceExtensionEnabler((MetadataExtractor)this.metadataExtractorProducer.get()));
        if (((PersistenceExtensionEnabler)this.persistenceExtensionEnabler.get()).shouldPersistenceExtensionBeActivated()) {
            this.initializeConfigurationEvent.fire((Object)new InitializeConfiguration());
            this.beforePersistenceClassEvent.fire((Object)new BeforePersistenceClass(beforeClass.getTestClass()));
        }
    }

    public void beforeTest(@Observes(precedence=25) Before beforeTestEvent) {
        PersistenceConfiguration persistenceConfiguration = (PersistenceConfiguration)this.configurationInstance.get();
        this.persistenceExtensionFeatureResolverProvider.set((Object)new PersistenceExtensionFeatureResolver(beforeTestEvent.getTestMethod(), (MetadataExtractor)this.metadataExtractorProducer.get(), persistenceConfiguration));
        this.persistenceExtensionScriptingFeatureResolverProvider.set((Object)new PersistenceExtensionScriptingFeatureResolver(beforeTestEvent.getTestMethod(), (MetadataExtractor)this.metadataExtractorProducer.get(), (ScriptingConfiguration)this.scriptingConfigurationInstance.get()));
        if (((PersistenceExtensionEnabler)this.persistenceExtensionEnabler.get()).shouldPersistenceExtensionBeActivated()) {
            this.createDataSource();
            this.beforePersistenceTestEvent.fire((Object)new BeforePersistenceTest((TestEvent)beforeTestEvent));
        }
    }

    public void afterTest(@Observes(precedence=25) After afterTestEvent) {
        if (((PersistenceExtensionEnabler)this.persistenceExtensionEnabler.get()).shouldPersistenceExtensionBeActivated()) {
            this.afterPersistenceTestEvent.fire((Object)new AfterPersistenceTest((TestEvent)afterTestEvent));
        }
    }

    private void createDataSource() {
        String dataSourceName = ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverProvider.get()).getDataSourceName();
        this.dataSourceProducer.set((Object)this.loadDataSource(dataSourceName));
    }

    private DataSource loadDataSource(String dataSourceName) {
        try {
            Context context = (Context)this.contextInstance.get();
            if (context == null) {
                throw new ContextNotAvailableException("No Naming Context available.");
            }
            return (DataSource)context.lookup(dataSourceName);
        }
        catch (NamingException e) {
            throw new DataSourceNotFoundException("Unable to find data source for given name: " + dataSourceName, e);
        }
    }
}

