/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.lifecycle;

import java.util.Collection;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.persistence.core.command.SchemaCreationControlCommand;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.event.ExecuteScripts;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.descriptor.SqlScriptResourceDescriptor;
import org.jboss.arquillian.persistence.script.data.provider.SqlScriptProvider;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaCreationScriptsExecutor {
    @Inject
    private Instance<ScriptingConfiguration> configuration;
    @Inject
    private Event<ExecuteScripts> executeScriptsEvent;
    @Inject
    private Instance<CommandService> commandService;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolver;

    public void createSchema(@Observes(precedence=10) EventContext<BeforePersistenceTest> context) {
        Collection<SqlScriptResourceDescriptor> schemaDescriptors;
        BeforePersistenceTest beforePersistenceTest = (BeforePersistenceTest)((Object)context.getEvent());
        if (((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolver.get()).shouldCreateSchema() && !this.schemaCreated(beforePersistenceTest) && !(schemaDescriptors = SqlScriptProvider.createProviderForCreateSchemaScripts(beforePersistenceTest.getTestClass(), (ScriptingConfiguration)this.configuration.get()).getDescriptors(beforePersistenceTest.getTestClass())).isEmpty()) {
            this.executeScriptsEvent.fire((Object)new ExecuteScripts(beforePersistenceTest, schemaDescriptors));
        }
        context.proceed();
    }

    private boolean schemaCreated(TestEvent beforePersistenceTest) {
        return (Boolean)((CommandService)this.commandService.get()).execute((Command)new SchemaCreationControlCommand(beforePersistenceTest.getTestInstance().getClass().getSimpleName()));
    }
}

