/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.metadata;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.persistence.ApplyScriptAfter;
import org.jboss.arquillian.persistence.ApplyScriptBefore;
import org.jboss.arquillian.persistence.Cleanup;
import org.jboss.arquillian.persistence.CleanupUsingScript;
import org.jboss.arquillian.persistence.CreateSchema;
import org.jboss.arquillian.persistence.DataSource;
import org.jboss.arquillian.persistence.JpaCacheEviction;
import org.jboss.arquillian.persistence.PersistenceTest;
import org.jboss.arquillian.persistence.SeedDataUsing;
import org.jboss.arquillian.persistence.ShouldMatchDataSet;
import org.jboss.arquillian.persistence.UsingDataSet;
import org.jboss.arquillian.persistence.core.metadata.AnnotationInspector;
import org.jboss.arquillian.test.spi.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataExtractor {
    private final TestClass testClass;
    private final Map<Class<?>, AnnotationInspector<?>> inspectors = new HashMap();

    public MetadataExtractor(TestClass testClass) {
        this.testClass = testClass;
    }

    public <K extends Annotation> void register(TestClass testClass, Class<K> annotation) {
        this.inspectors.put(annotation, new AnnotationInspector<K>(testClass, annotation));
    }

    public <K extends Annotation> AnnotationInspector<K> using(Class<K> annotation) {
        if (this.inspectors.get(annotation) == null) {
            this.register(this.testClass, annotation);
        }
        return this.inspectors.get(annotation);
    }

    public AnnotationInspector<DataSource> dataSource() {
        return this.using(DataSource.class);
    }

    public AnnotationInspector<SeedDataUsing> dataSeedStrategy() {
        return this.using(SeedDataUsing.class);
    }

    public AnnotationInspector<UsingDataSet> usingDataSet() {
        return this.using(UsingDataSet.class);
    }

    public AnnotationInspector<ShouldMatchDataSet> shouldMatchDataSet() {
        return this.using(ShouldMatchDataSet.class);
    }

    public AnnotationInspector<ApplyScriptBefore> applyScriptBefore() {
        return this.using(ApplyScriptBefore.class);
    }

    public AnnotationInspector<ApplyScriptAfter> applyScriptAfter() {
        return this.using(ApplyScriptAfter.class);
    }

    public AnnotationInspector<Cleanup> cleanup() {
        return this.using(Cleanup.class);
    }

    public AnnotationInspector<CleanupUsingScript> cleanupUsingScript() {
        return this.using(CleanupUsingScript.class);
    }

    public AnnotationInspector<JpaCacheEviction> jpaCacheEviction() {
        return this.using(JpaCacheEviction.class);
    }

    public AnnotationInspector<CreateSchema> createSchema() {
        return this.using(CreateSchema.class);
    }

    public boolean hasPersistenceTestAnnotation() {
        return this.testClass.getAnnotation(PersistenceTest.class) != null;
    }

    public Class<?> getJavaClass() {
        return this.testClass.getJavaClass();
    }
}

