/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.metadata;

import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.test.spi.TestClass;

public class PersistenceExtensionEnabler {
    private final MetadataExtractor metadataExtractor;

    public PersistenceExtensionEnabler(TestClass testClass) {
        this.metadataExtractor = new MetadataExtractor(testClass);
    }

    public PersistenceExtensionEnabler(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public boolean shouldPersistenceExtensionBeActivated() {
        return this.hasDataSetAnnotation() || this.hasApplyScriptAnnotation() || this.hasPersistenceTestAnnotation() || this.hasJpaCacheEvictionAnnotation() || this.hasCreateSchemaAnnotation() || this.hasCleanupAnnotation() || this.hasCleanupUsingScriptAnnotation();
    }

    private boolean hasDataSetAnnotation() {
        return this.metadataExtractor.usingDataSet().isDefinedOnClassLevel() || this.metadataExtractor.usingDataSet().isDefinedOnAnyMethod() || this.metadataExtractor.shouldMatchDataSet().isDefinedOnClassLevel() || this.metadataExtractor.shouldMatchDataSet().isDefinedOnAnyMethod();
    }

    private boolean hasApplyScriptAnnotation() {
        return this.metadataExtractor.applyScriptBefore().isDefinedOnClassLevel() || this.metadataExtractor.applyScriptBefore().isDefinedOnAnyMethod() || this.metadataExtractor.applyScriptAfter().isDefinedOnClassLevel() || this.metadataExtractor.applyScriptAfter().isDefinedOnAnyMethod();
    }

    private boolean hasPersistenceTestAnnotation() {
        return this.metadataExtractor.hasPersistenceTestAnnotation();
    }

    private boolean hasJpaCacheEvictionAnnotation() {
        return this.metadataExtractor.jpaCacheEviction().isDefinedOnClassLevel() || this.metadataExtractor.jpaCacheEviction().isDefinedOnAnyMethod();
    }

    private boolean hasCreateSchemaAnnotation() {
        return this.metadataExtractor.createSchema().isDefinedOnClassLevel();
    }

    private boolean hasCleanupAnnotation() {
        return this.metadataExtractor.cleanup().isDefinedOnClassLevel() || this.metadataExtractor.cleanup().isDefinedOnAnyMethod();
    }

    private boolean hasCleanupUsingScriptAnnotation() {
        return this.metadataExtractor.cleanupUsingScript().isDefinedOnClassLevel() || this.metadataExtractor.cleanupUsingScript().isDefinedOnAnyMethod();
    }
}

