/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.metadata;

import java.lang.reflect.Method;
import org.jboss.arquillian.persistence.CleanupUsingScript;
import org.jboss.arquillian.persistence.TestExecutionPhase;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;

public class PersistenceExtensionScriptingFeatureResolver {
    private final ScriptingConfiguration configuration;
    private final MetadataExtractor metadataExtractor;
    private final Method testMethod;

    public PersistenceExtensionScriptingFeatureResolver(Method testMethod, MetadataExtractor metadataExtractor, ScriptingConfiguration configuration) {
        this.metadataExtractor = metadataExtractor;
        this.configuration = configuration;
        this.testMethod = testMethod;
    }

    public TestExecutionPhase getCleanupUsingScriptTestPhase() {
        CleanupUsingScript cleanupAnnotation = this.metadataExtractor.cleanupUsingScript().fetchUsingFirst(this.testMethod);
        TestExecutionPhase phase = this.configuration.getDefaultCleanupUsingScriptPhase();
        if (cleanupAnnotation != null && !TestExecutionPhase.DEFAULT.equals((Object)cleanupAnnotation.phase())) {
            phase = cleanupAnnotation.phase();
        }
        return phase;
    }

    public boolean shouldCleanupUsingScript() {
        return this.metadataExtractor.cleanupUsingScript().fetchUsingFirst(this.testMethod) != null;
    }

    public boolean shouldCleanupUsingScriptBefore() {
        return this.shouldCleanupUsingScript() && TestExecutionPhase.BEFORE.equals((Object)this.getCleanupUsingScriptTestPhase());
    }

    public boolean shouldCleanupUsingScriptAfter() {
        return this.shouldCleanupUsingScript() && TestExecutionPhase.AFTER.equals((Object)this.getCleanupUsingScriptTestPhase());
    }
}

