/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.core.test;

import java.util.ArrayList;
import java.util.List;

public class AssertionErrorCollector {
    private final List<String> assertionErrors = new ArrayList<String>();

    public void collect(AssertionError error) {
        this.collect(((Throwable)((Object)error)).getMessage());
    }

    public void collect(String errorMessage) {
        this.assertionErrors.add(errorMessage);
    }

    public void report() {
        if (this.assertionErrors.isEmpty()) {
            return;
        }
        throw new AssertionError((Object)this.createErrorMessage());
    }

    public int amountOfErrors() {
        return this.assertionErrors.size();
    }

    private String createErrorMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("Test failed in " + this.amountOfErrors() + " case" + (this.amountOfErrors() > 1 ? "s" : "") + ". \n");
        for (String errorMessage : this.assertionErrors) {
            builder.append(errorMessage).append('\n');
        }
        String errorMessage = builder.toString();
        return errorMessage;
    }
}

