/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.sql.SQLException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ExcludeTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.CleanupStrategy;
import org.jboss.arquillian.persistence.DataSeedStrategy;
import org.jboss.arquillian.persistence.core.data.DataHandler;
import org.jboss.arquillian.persistence.core.event.CleanupData;
import org.jboss.arquillian.persistence.core.event.CleanupDataUsingScript;
import org.jboss.arquillian.persistence.core.event.CompareData;
import org.jboss.arquillian.persistence.core.event.ExecuteScripts;
import org.jboss.arquillian.persistence.core.event.PrepareData;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.core.test.AssertionErrorCollector;
import org.jboss.arquillian.persistence.dbunit.DataSetComparator;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyProvider;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitDataSeedStrategyProvider;
import org.jboss.arquillian.persistence.dbunit.dataset.DataSetRegister;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitConnectionException;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;
import org.jboss.arquillian.persistence.script.ScriptExecutor;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.descriptor.SqlScriptResourceDescriptor;

public class DBUnitDataHandler
implements DataHandler {
    @Inject
    private Instance<DatabaseConnection> databaseConnection;
    @Inject
    private Instance<DataSetRegister> dataSetRegister;
    @Inject
    private Instance<AssertionErrorCollector> assertionErrorCollector;
    @Inject
    private Instance<DBUnitConfiguration> dbunitConfigurationInstance;
    @Inject
    private Instance<ScriptingConfiguration> scriptConfigurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;

    public void prepare(@Observes PrepareData prepareDataEvent) {
        try {
            this.fillDatabase();
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Failed while seeding database.", e);
        }
    }

    public void compare(@Observes CompareData compareDataEvent) {
        try {
            IDataSet currentDataSet = ((DatabaseConnection)this.databaseConnection.get()).createDataSet();
            String[] excludeTablesFromComparisonWhenEmptyExpected = ((DBUnitConfiguration)this.dbunitConfigurationInstance.get()).getExcludeTablesFromComparisonWhenEmptyExpected();
            if (excludeTablesFromComparisonWhenEmptyExpected.length != 0) {
                currentDataSet = new FilteredDataSet((ITableFilter)new ExcludeTableFilter(excludeTablesFromComparisonWhenEmptyExpected), currentDataSet);
            }
            IDataSet expectedDataSet = DataSetUtils.mergeDataSets(((DataSetRegister)this.dataSetRegister.get()).getExpected());
            new DataSetComparator(compareDataEvent.getSortByColumns(), compareDataEvent.getColumnsToExclude()).compare(currentDataSet, expectedDataSet, (AssertionErrorCollector)this.assertionErrorCollector.get());
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Failed while comparing database state with provided data sets.", e);
        }
    }

    public void cleanup(@Observes CleanupData cleanupDataEvent) {
        this.cleanDatabase(cleanupDataEvent.cleanupStrategy);
    }

    public void cleanupUsingScript(@Observes CleanupDataUsingScript cleanupDataUsingScriptEvent) {
        for (SqlScriptResourceDescriptor scriptDescriptor : cleanupDataUsingScriptEvent.getDescriptors()) {
            String script = (String)scriptDescriptor.getContent();
            this.executeScript(script);
        }
    }

    public void executeScripts(@Observes ExecuteScripts executeScriptsEvent) {
        for (SqlScriptResourceDescriptor scriptDescriptor : executeScriptsEvent.getDescriptors()) {
            String script = (String)scriptDescriptor.getContent();
            this.executeScript(script);
        }
    }

    private void executeScript(String script) {
        try {
            ScriptExecutor scriptExecutor = new ScriptExecutor(((DatabaseConnection)this.databaseConnection.get()).getConnection());
            scriptExecutor.setStatementDelimiter(((ScriptingConfiguration)this.scriptConfigurationInstance.get()).getSqlStatementDelimiter());
            scriptExecutor.execute(script);
        }
        catch (SQLException e) {
            throw new DBUnitConnectionException("Unable to obtain JDBC connection", e);
        }
    }

    private void fillDatabase() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)this.databaseConnection.get();
        IDataSet initialDataSet = DataSetUtils.mergeDataSets(((DataSetRegister)this.dataSetRegister.get()).getInitial());
        initialDataSet = new FilteredDataSet((ITableFilter)new DatabaseSequenceFilter((IDatabaseConnection)connection), initialDataSet);
        this.getSelectedSeedingStrategy().execute((IDatabaseConnection)connection, initialDataSet);
    }

    private DatabaseOperation getSelectedSeedingStrategy() {
        DBUnitConfiguration dbUnitConfiguration = (DBUnitConfiguration)this.dbunitConfigurationInstance.get();
        DataSeedStrategy dataSeedStrategy = ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).getDataSeedStrategy();
        boolean useIdentityInsert = dbUnitConfiguration.isUseIdentityInsert();
        DatabaseOperation selectedSeedingStrategy = (DatabaseOperation)dataSeedStrategy.provide((DataSeedStrategy.StrategyProvider)new DBUnitDataSeedStrategyProvider(useIdentityInsert));
        return selectedSeedingStrategy;
    }

    private void cleanDatabase(CleanupStrategy cleanupStrategy) {
        CleanupStrategyExecutor cleanupStrategyExecutor = (CleanupStrategyExecutor)cleanupStrategy.provide((CleanupStrategy.StrategyProvider)new CleanupStrategyProvider((DatabaseConnection)this.databaseConnection.get(), (DataSetRegister)this.dataSetRegister.get()));
        cleanupStrategyExecutor.cleanupDatabase(((DBUnitConfiguration)this.dbunitConfigurationInstance.get()).getExcludeTablesFromCleanup());
    }
}

