/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.persistence.core.command.DumpDataCommand;
import org.jboss.arquillian.persistence.core.configuration.PersistenceConfiguration;
import org.jboss.arquillian.persistence.core.data.dump.DataDump;
import org.jboss.arquillian.persistence.core.data.dump.DataStateLogger;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.event.CleanupData;
import org.jboss.arquillian.persistence.core.event.PersistenceEvent;
import org.jboss.arquillian.persistence.core.event.PrepareData;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;
import org.jboss.arquillian.test.spi.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUnitDataStateLogger
implements DataStateLogger {
    private static final String FILENAME_PATTERN = "[%s]-%s#%s-%s.xml";
    @Inject
    private Instance<DatabaseConnection> databaseConnection;
    @Inject
    private Instance<PersistenceConfiguration> configuration;
    @Inject
    private Instance<CommandService> commandService;
    private TestClass testClass;
    private Method testMethod;

    @Override
    public void beforePersistenceTest(@Observes EventContext<BeforePersistenceTest> context) {
        this.testClass = ((BeforePersistenceTest)((Object)context.getEvent())).getTestClass();
        this.testMethod = ((BeforePersistenceTest)((Object)context.getEvent())).getTestMethod();
        context.proceed();
    }

    @Override
    public void aroundDataSeeding(@Observes EventContext<PrepareData> context) {
        if (!((PersistenceConfiguration)this.configuration.get()).isDumpData()) {
            context.proceed();
            return;
        }
        PrepareData event = (PrepareData)context.getEvent();
        this.dumpDatabaseState(event, Phase.BEFORE_SEED);
        context.proceed();
        this.dumpDatabaseState(event, Phase.AFTER_SEED);
    }

    @Override
    public void aroundCleanup(@Observes EventContext<CleanupData> context) {
        if (!((PersistenceConfiguration)this.configuration.get()).isDumpData()) {
            context.proceed();
            return;
        }
        CleanupData event = (CleanupData)context.getEvent();
        this.dumpDatabaseState(event, Phase.BEFORE_CLEAN);
        context.proceed();
        this.dumpDatabaseState(event, Phase.AFTER_CLEAN);
    }

    private String createFileName(String phaseSuffix) {
        return String.format(FILENAME_PATTERN, System.currentTimeMillis(), this.testClass.getName(), this.testMethod.getName(), phaseSuffix);
    }

    private void dumpDatabaseState(PersistenceEvent event, Phase phase) {
        String path = ((PersistenceConfiguration)this.configuration.get()).getDumpDirectory() + "/" + this.createFileName(phase.getName());
        try {
            IDataSet dbContent = ((DatabaseConnection)this.databaseConnection.get()).createDataSet();
            DataDump dumpData = this.createDataDump(path, dbContent);
            ((CommandService)this.commandService.get()).execute((Command)new DumpDataCommand(dumpData));
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to dump database state to folder " + path, e);
        }
    }

    private DataDump createDataDump(String path, IDataSet dbContent) throws IOException, DataSetException {
        StringWriter stringWriter = new StringWriter();
        FlatXmlDataSet.write((IDataSet)dbContent, (Writer)stringWriter);
        DataDump dumpData = new DataDump(stringWriter.toString(), path);
        stringWriter.close();
        return dumpData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Phase {
        BEFORE_SEED("before-seed"),
        AFTER_SEED("after-seed"),
        BEFORE_CLEAN("before-clean"),
        AFTER_CLEAN("after-clean");

        private final String name;

        private Phase(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

