/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.filter.ExcludeTableFilter;
import org.dbunit.dataset.filter.ITableFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetUtils {
    public static IDataSet mergeDataSets(List<IDataSet> dataSets) throws DataSetException {
        return new CompositeDataSet(dataSets.toArray(new IDataSet[dataSets.size()]));
    }

    public static List<String> extractColumnsNotSpecifiedInExpectedDataSet(ITable expectedTableState, ITable currentTableState) throws DataSetException {
        HashSet<String> allColumns = new HashSet<String>(DataSetUtils.extractColumnNames(currentTableState.getTableMetaData().getColumns()));
        HashSet<String> expectedColumnNames = new HashSet<String>(DataSetUtils.extractColumnNames(expectedTableState.getTableMetaData().getColumns()));
        return DataSetUtils.extractNonExistingColumns(allColumns, expectedColumnNames);
    }

    public static List<String> extractNonExistingColumns(Collection<String> expectedColumns, Collection<String> actualColumns) {
        ArrayList<String> columnsNotSpecifiedInExpectedDataSet = new ArrayList<String>();
        for (String column : expectedColumns) {
            if (actualColumns.contains(column.toLowerCase())) continue;
            columnsNotSpecifiedInExpectedDataSet.add(column.toLowerCase());
        }
        return columnsNotSpecifiedInExpectedDataSet;
    }

    public static Collection<String> extractColumnNames(Column[] columns) {
        ArrayList<String> names = new ArrayList<String>(columns.length);
        for (Column column : columns) {
            names.add(column.getColumnName().toLowerCase());
        }
        return names;
    }

    public static IDataSet excludeTables(IDataSet dataSet, String ... tablesToExclude) {
        return new FilteredDataSet((ITableFilter)new ExcludeTableFilter(tablesToExclude), dataSet);
    }
}

