/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.cleanup;

import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.dataset.DataSetRegister;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;

public class SeededDataOnlyCleanupStrategyExecutor
implements CleanupStrategyExecutor {
    private final DatabaseConnection connection;
    private final DataSetRegister dataSetRegister;

    public SeededDataOnlyCleanupStrategyExecutor(DatabaseConnection connection, DataSetRegister dataSetRegister) {
        this.connection = connection;
        this.dataSetRegister = dataSetRegister;
    }

    public void cleanupDatabase(String ... tablesToExclude) {
        try {
            IDataSet mergeDataSets = DataSetUtils.mergeDataSets(this.dataSetRegister.getInitial());
            IDataSet dataSet = DataSetUtils.excludeTables(mergeDataSets, tablesToExclude);
            dataSet = new FilteredDataSet((ITableFilter)new DatabaseSequenceFilter((IDatabaseConnection)this.connection), dataSet);
            DatabaseOperation.DELETE.execute((IDatabaseConnection)this.connection, dataSet);
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to clean database.", e);
        }
    }
}

