/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.cleanup;

import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;

public class StrictCleanupStrategyExecutor
implements CleanupStrategyExecutor {
    private final DatabaseConnection connection;

    public StrictCleanupStrategyExecutor(DatabaseConnection connection) {
        this.connection = connection;
    }

    public void cleanupDatabase(String ... tablesToExclude) {
        try {
            IDataSet dataSet = DataSetUtils.excludeTables(this.connection.createDataSet(), tablesToExclude);
            dataSet = new FilteredDataSet((ITableFilter)new DatabaseSequenceFilter((IDatabaseConnection)this.connection), dataSet);
            DatabaseOperation.DELETE_ALL.execute((IDatabaseConnection)this.connection, dataSet);
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to clean database.", e);
        }
    }
}

