/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.data.descriptor;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Format {
    XML("xml"),
    EXCEL("xls"),
    YAML("yml"),
    JSON("json"),
    UNSUPPORTED("-none-");

    private static final EnumSet<Format> NOT_REAL_FILE_TYPES;
    private final String fileExtension;

    private Format(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String extension() {
        return this.fileExtension;
    }

    public static Format inferFromFile(String fileName) {
        Format result = UNSUPPORTED;
        EnumSet<Format> validFormats = EnumSet.complementOf(NOT_REAL_FILE_TYPES);
        for (Format format : validFormats) {
            if (!fileName.endsWith(format.fileExtension)) continue;
            return format;
        }
        return result;
    }

    static {
        NOT_REAL_FILE_TYPES = EnumSet.of(UNSUPPORTED);
    }
}

