/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.dataset;

import java.io.IOException;
import java.io.InputStream;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.jboss.arquillian.persistence.dbunit.data.descriptor.Format;
import org.jboss.arquillian.persistence.dbunit.dataset.json.JsonDataSet;
import org.jboss.arquillian.persistence.dbunit.dataset.xml.DtdResolver;
import org.jboss.arquillian.persistence.dbunit.dataset.yaml.YamlDataSet;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitInitializationException;
import org.yaml.snakeyaml.Yaml;

public class DataSetBuilder {
    private final Format format;

    private DataSetBuilder(Format format) {
        this.format = format;
    }

    public IDataSet build(String file) {
        Object dataSet = null;
        try {
            switch (this.format) {
                case XML: {
                    dataSet = this.loadXmlDataSet(file);
                    break;
                }
                case EXCEL: {
                    dataSet = this.loadExcelDataSet(file);
                    break;
                }
                case YAML: {
                    dataSet = this.loadYamlDataSet(file);
                    break;
                }
                case JSON: {
                    dataSet = this.loadJsonDataSet(file);
                    break;
                }
                default: {
                    throw new DBUnitInitializationException("Unsupported data type " + (Object)((Object)this.format));
                }
            }
        }
        catch (Exception e) {
            throw new DBUnitInitializationException("Unable to load data set from given file: " + file, e);
        }
        return this.defineReplaceableExpressions((IDataSet)dataSet);
    }

    public static DataSetBuilder builderFor(Format format) {
        return new DataSetBuilder(format);
    }

    private IDataSet loadXmlDataSet(String xmlFile) throws DataSetException {
        FlatXmlDataSetBuilder flatXmlDataSetBuilder = new FlatXmlDataSetBuilder();
        flatXmlDataSetBuilder.setColumnSensing(true);
        this.addDtdIfDefined(flatXmlDataSetBuilder, xmlFile);
        return flatXmlDataSetBuilder.build(Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile));
    }

    private void addDtdIfDefined(FlatXmlDataSetBuilder flatXmlDataSetBuilder, String xmlFile) {
        String dtd = new DtdResolver().resolveDtdLocationFullPath(xmlFile);
        if (dtd != null) {
            try {
                flatXmlDataSetBuilder.setMetaDataSetFromDtd(Thread.currentThread().getContextClassLoader().getResourceAsStream(dtd));
            }
            catch (DataSetException e) {
                throw new DBUnitInitializationException("Unable to attach DTD " + dtd + " defined for " + xmlFile, e);
            }
            catch (IOException e) {
                throw new DBUnitInitializationException("Unable to attach DTD " + dtd + " defined for " + xmlFile, e);
            }
        }
    }

    private XlsDataSet loadExcelDataSet(String file) throws IOException, DataSetException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        return new XlsDataSet(inputStream);
    }

    private JsonDataSet loadJsonDataSet(String file) throws IOException, DataSetException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        return new JsonDataSet(inputStream);
    }

    private IDataSet loadYamlDataSet(String file) throws IOException, DataSetException {
        Object dataSet;
        if (this.isYamlEmpty(file)) {
            dataSet = new DefaultDataSet();
        } else {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            dataSet = new YamlDataSet(inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return dataSet;
    }

    private boolean isYamlEmpty(String yamlFile) throws IOException {
        boolean isEmpty;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(yamlFile);
        boolean bl = isEmpty = new Yaml().load(inputStream) == null;
        if (inputStream != null) {
            inputStream.close();
        }
        return isEmpty;
    }

    private IDataSet defineReplaceableExpressions(IDataSet dataSet) {
        ReplacementDataSet replacementDataSet = new ReplacementDataSet(dataSet);
        replacementDataSet.addReplacementObject((Object)"[null]", null);
        replacementDataSet.addReplacementObject((Object)"[NULL]", null);
        return replacementDataSet;
    }
}

