/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.dataset.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.dbunit.dataset.DataSetException;
import org.jboss.arquillian.persistence.dbunit.dataset.json.DataSetProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonDataSetProducer
extends DataSetProducer {
    public JsonDataSetProducer(InputStream input) {
        super(input);
    }

    @Override
    Map<String, List<Map<String, String>>> loadDataSet() throws DataSetException {
        Map dataset = Collections.emptyMap();
        try {
            dataset = (Map)new ObjectMapper().readValue(this.input, Map.class);
        }
        catch (JsonParseException e) {
            throw new DataSetException("Error parsing json data set", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new DataSetException("Error mapping json data set", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataSetException("Error opening json data set", (Throwable)e);
        }
        return dataset;
    }
}

