/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.script;

import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptExecutor {
    private static final String ANSI_SQL_COMMENTS_PATTERN = "--.*|//.*|(?s)/\\\\*.*?\\\\*/|(?s)\\{.*?\\}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String DEFAULT_SQL_DELIMITER = ";";
    private final Connection connection;
    private String statementDelimiter = ";";
    private boolean fullLineDelimiter = false;

    public ScriptExecutor(Connection connection) {
        this.connection = connection;
    }

    public void execute(String script) {
        ArrayList<String> statements = new ArrayList<String>();
        try {
            script = this.removeComments(script);
            BufferedReader lineReader = new BufferedReader(new StringReader(script));
            StringBuilder readSqlStatement = new StringBuilder();
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                boolean isFullCommand = this.parseLine(line, readSqlStatement);
                if (!isFullCommand) continue;
                if (this.multipleInlineStatements(line)) {
                    statements.addAll(this.splitInlineStatements(line));
                } else {
                    statements.add(readSqlStatement.toString().trim());
                }
                readSqlStatement.setLength(0);
            }
            if (this.shouldExecuteRemainingStatements(readSqlStatement)) {
                statements.add(readSqlStatement.toString().trim());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed parsing file.", e);
        }
        for (String statement : statements) {
            this.executeStatement(statement);
        }
    }

    private String removeComments(String script) {
        return script.replaceAll(ANSI_SQL_COMMENTS_PATTERN, "");
    }

    void executeStatement(String sqlStatement) {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute(sqlStatement);
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to execute statement: " + sqlStatement, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new DBUnitDataSetHandlingException("Unable to close statement after script execution.", e);
                }
            }
        }
    }

    private boolean parseLine(String line, StringBuilder sql) {
        String trimmedLine = this.trim(line);
        sql.append(trimmedLine).append(LINE_SEPARATOR);
        return this.isFullCommand(trimmedLine);
    }

    private String trim(String line) {
        return line.trim() + (this.isNewLineStatementDelimiter() ? LINE_SEPARATOR : "");
    }

    private boolean shouldExecuteRemainingStatements(StringBuilder sql) {
        return sql.toString().trim().length() > 0;
    }

    private boolean isNewLineStatementDelimiter() {
        return "NEW_LINE".equals(this.getStatementDelimiter());
    }

    private List<String> splitInlineStatements(String line) {
        ArrayList<String> statements = new ArrayList<String>();
        StringTokenizer sqlStatements = new StringTokenizer(line, this.getStatementDelimiter());
        while (sqlStatements.hasMoreElements()) {
            statements.add(sqlStatements.nextToken().trim());
        }
        return statements;
    }

    private boolean multipleInlineStatements(String line) {
        if (this.isNewLineStatementDelimiter()) {
            return false;
        }
        return new StringTokenizer(line, this.getStatementDelimiter()).countTokens() > 1;
    }

    private boolean isFullCommand(String line) {
        return !this.fullLineDelimiter && this.lineEndsWithStatementDelimiter(line) || this.fullLineDelimiter && this.lineIsStatementDelimiter(line);
    }

    private boolean lineIsStatementDelimiter(String line) {
        boolean isStatementDelimiter = line.equals(this.getStatementDelimiter());
        if (!isStatementDelimiter && this.isNewLineStatementDelimiter()) {
            isStatementDelimiter = line.matches("^\\r?\\n|\\r$");
        }
        return isStatementDelimiter;
    }

    private boolean lineEndsWithStatementDelimiter(String line) {
        boolean ends = line.endsWith(this.getStatementDelimiter());
        if (!ends && this.isNewLineStatementDelimiter()) {
            ends = line.matches("^.+?\\r?\\n|^.+?\\r$");
        }
        return ends;
    }

    public String getStatementDelimiter() {
        return this.statementDelimiter;
    }

    public void setStatementDelimiter(String statementDelimiter) {
        this.statementDelimiter = statementDelimiter;
    }

    public boolean isFullLineDelimiter() {
        return this.fullLineDelimiter;
    }

    public void setFullLineDelimiter(boolean fullLineDelimiter) {
        this.fullLineDelimiter = fullLineDelimiter;
    }
}

