/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jboss.arquillian.persistence.core.exception.DataSetLoadingException;

public final class ScriptLoader {
    public static String loadScript(String location) {
        StringBuilder builder = new StringBuilder();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        BufferedReader reader = null;
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\r\n");
            }
        }
        catch (Exception e) {
            throw new DataSetLoadingException("Failed loading script " + location, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new DataSetLoadingException("Unable to close script.", e);
                }
            }
        }
        return builder.toString();
    }

    public static boolean isSqlScriptFile(String script) {
        if (script == null) {
            return false;
        }
        return script.endsWith(".sql");
    }
}

